/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.recorder;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LifetimeRecorderConfig {
    private static final Path BASE_DIR = Paths.get("config", CarpetTISAdditionMod.COMPACT_NAME, "lifetime");
    public static final Path CONFIG_FILE_PATH = BASE_DIR.resolve("recorder_config.json");
    public boolean enabled = false;
    public int requiredPermissionLevel = 4;
    public boolean consoleOrSinglePlayerOwnerOnly = true;
    public String outputDirectory = BASE_DIR.resolve("records").toString();
    public long maxOutputRecordCount = -1L;
    public long maxOutputFileBytes = 0x6400000L;
    public long maxTotalOutputFileCount = 500L;
    public long maxTotalOutputFileBytes = 0x40000000L;
    public double sampleRate = 1.0;

    public static LifetimeRecorderConfig load() {
        LifetimeRecorderConfig config = new LifetimeRecorderConfig();
        try {
            if (FileUtils.isFile(CONFIG_FILE_PATH.toFile())) {
                config = LifetimeRecorderConfig.loadNoCheck();
            }
        }
        catch (Exception e) {
            CarpetTISAdditionServer.LOGGER.error("Failed to load lifetime recorder config file", (Throwable)e);
        }
        config.save();
        return config;
    }

    public static LifetimeRecorderConfig loadNoCheck() throws IOException {
        try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(CONFIG_FILE_PATH, new OpenOption[0]), StandardCharsets.UTF_8);){
            LifetimeRecorderConfig lifetimeRecorderConfig = (LifetimeRecorderConfig)new Gson().fromJson((Reader)isr, LifetimeRecorderConfig.class);
            return lifetimeRecorderConfig;
        }
    }

    public void save() {
        try {
            FileUtils.touchDirectory(BASE_DIR);
            Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
            String content = gson.toJson((Object)this);
            try (BufferedWriter fw = Files.newBufferedWriter(CONFIG_FILE_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                fw.write(content);
            }
        }
        catch (Exception e) {
            CarpetTISAdditionServer.LOGGER.error("Failed to save lifetime recorder config file", (Throwable)e);
        }
    }
}

