/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.recorder;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.commands.lifetime.interfaces.LifetimeTrackerTarget;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.utils.AbstractReason;
import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.gson.IdentifierAdaptor;
import carpettisaddition.utils.gson.Vec3dAdaptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class Record {
    public long serverTick;
    public long gameTime;
    public String eventType;
    public String eventId;
    public class_243 eventPosition;
    public JsonElement eventData;
    public class_2960 entityType;
    public int entityId;
    public UUID entityUuid;
    public class_243 entityPosition;
    public class_2960 entityDimension;
    public long entityLifetime;
    public static final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(class_2960.class, (Object)new IdentifierAdaptor()).registerTypeAdapter(class_243.class, (Object)new Vec3dAdaptor()).create();

    public static Record create(class_1297 entity, EventType eventType, String eventId, JsonElement eventData) {
        Record r = new Record();
        LifetimeTrackerTarget ltt = (LifetimeTrackerTarget)entity;
        r.serverTick = CarpetTISAdditionServer.minecraft_server.method_3780();
        r.gameTime = GameUtils.getGameTime();
        r.eventId = eventId;
        r.eventType = eventType.name().toLowerCase();
        r.eventPosition = eventType == EventType.SPAWNING ? ltt.getSpawningPosition() : ltt.getRemovalPosition();
        r.eventData = eventData;
        r.entityType = class_1299.method_5890((class_1299)entity.method_5864());
        r.entityId = entity.method_5628();
        r.entityUuid = entity.method_5667();
        r.entityPosition = entity.method_19538();
        r.entityDimension = DimensionWrapper.of(entity).getIdentifier();
        r.entityLifetime = eventType == EventType.SPAWNING ? 0L : ltt.getLifeTime();
        return r;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static enum EventType {
        SPAWNING,
        REMOVAL;


        public static EventType fromReason(AbstractReason reason) {
            if (reason instanceof SpawningReason) {
                return SPAWNING;
            }
            if (reason instanceof RemovalReason) {
                return REMOVAL;
            }
            throw new IllegalArgumentException("unknown reason " + String.valueOf(reason));
        }
    }
}

