/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.portalCreation;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingAccess;
import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.entityfilter.EntityFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PortalCreationLogger
extends AbstractLogger {
    public static final String NAME = "portalCreation";
    public static final ThreadLocal<class_1297> entityThatCreatesThePortal = ThreadLocal.withInitial(() -> null);
    private static final PortalCreationLogger INSTANCE = new PortalCreationLogger();

    private PortalCreationLogger() {
        super(NAME, false);
    }

    public static PortalCreationLogger getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String[] getSuggestedLoggingOption() {
        return new String[]{"all", "players", "me", "@e[type=creeper]", "@e[type=!player]"};
    }

    public void onNetherPortalCreation(class_3218 world, class_2338 portalPos, boolean floating) {
        if (!TISAdditionLoggerRegistry.__portalCreation) {
            return;
        }
        class_1297 entity = entityThatCreatesThePortal.get();
        if (entity == null) {
            return;
        }
        this.log((option, player) -> {
            if (!this.shouldReportFor(player, option, entity)) {
                return null;
            }
            ArrayList lines = Lists.newArrayList();
            lines.add(this.pack(this.tr("created", Messenger.formatting(Messenger.entity(entity), class_124.field_1067), Messenger.dimensionColored(Messenger.coord((class_2382)portalPos, DimensionWrapper.of((class_1937)world)), DimensionWrapper.of((class_1937)world)), Messenger.c(Messenger.s((Object)GameUtils.getGameTime(), "q"), Messenger.s((Object)" ", class_124.field_1063), MicroTimingAccess.getTickPhase().toText("q")))));
            return (class_2561[])lines.toArray(new class_5250[0]);
        });
    }

    private class_5250 pack(class_5250 text) {
        String command = String.format("/log %s", this.getName());
        return Messenger.c(Messenger.fancy(Messenger.c("g [", "m PC", "g ] "), Messenger.s(command), Messenger.ClickEvents.suggestCommand(command)), text);
    }

    private boolean shouldReportFor(class_1657 player, String option, class_1297 entity) {
        switch (option) {
            case "all": {
                return true;
            }
            case "me": {
                return entity == player;
            }
            case "players": {
                return entity instanceof class_1657;
            }
        }
        return EntityFilter.createOptional(player, option).map(filter -> filter.test(entity)).orElse(false);
    }
}

