/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.raid;

import carpettisaddition.commands.raid.RaidTracker;
import carpettisaddition.logging.loggers.raid.IRaid;
import carpettisaddition.logging.loggers.raid.RaidLogger;
import net.minecraft.class_2338;
import net.minecraft.class_3765;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3765.class})
public abstract class RaidMixin
implements IRaid {
    @Shadow
    private int field_16623;
    private int previousBadOmenLevel;

    @Shadow
    public abstract boolean method_20023();

    @Inject(method={"<init>(ILnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="TAIL")})
    private void raidLogger_onConstruct(CallbackInfo ci) {
        RaidLogger.getInstance().onRaidCreated((class_3765)this);
    }

    @Override
    public void onRaidInvalidated$TISCM(RaidLogger.InvalidateReason reason) {
        RaidLogger.getInstance().onRaidInvalidated((class_3765)this, reason);
        RaidTracker.getInstance().trackRaidInvalidated(reason);
    }

    @Inject(method={"start"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getStatusEffect(Lnet/minecraft/registry/entry/RegistryEntry;)Lnet/minecraft/entity/effect/StatusEffectInstance;")})
    private void raidLogger_onStartBeforeCalculated(CallbackInfoReturnable<Boolean> cir) {
        this.previousBadOmenLevel = this.field_16623;
    }

    @Inject(method={"start"}, at={@At(value="INVOKE_ASSIGN", shift=At.Shift.AFTER, target="Lnet/minecraft/util/math/MathHelper;clamp(III)I")})
    private void raidLogger_onStartedAfterCalculated(CallbackInfoReturnable<Boolean> cir) {
        if (this.field_16623 > 1 && this.field_16623 > this.previousBadOmenLevel) {
            RaidLogger.getInstance().onBadOmenLevelIncreased((class_3765)this, this.field_16623);
        }
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;getDifficulty()Lnet/minecraft/world/Difficulty;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void raidLogger_onInvalidatedByDifficulty(CallbackInfo ci) {
        this.onRaidInvalidated$TISCM(RaidLogger.InvalidateReason.DIFFICULTY_PEACEFUL);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;isNearOccupiedPointOfInterest(Lnet/minecraft/util/math/BlockPos;)Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void raidLogger_onInvalidatedByPOINotFound(CallbackInfo ci) {
        this.onRaidInvalidated$TISCM(RaidLogger.InvalidateReason.POI_REMOVED_BEFORE_SPAWN);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="CONSTANT", args={"longValue=48000"}, ordinal=0))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void raidLogger_onInvalidatedByTimeOut(CallbackInfo ci) {
        this.onRaidInvalidated$TISCM(RaidLogger.InvalidateReason.TIME_OUT);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;playRaidHorn(Lnet/minecraft/util/math/BlockPos;)V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void raidLogger_onInvalidatedByRaiderCannotSpawn(CallbackInfo ci) {
        this.onRaidInvalidated$TISCM(RaidLogger.InvalidateReason.RAIDER_CANNOT_SPAWN);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="CONSTANT", args={"intValue=600"}))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void raidLogger_onInvalidatedByFinished(CallbackInfo ci) {
        if (this.method_20023()) {
            this.onRaidInvalidated$TISCM(RaidLogger.InvalidateReason.RAID_VICTORY);
        } else {
            this.onRaidInvalidated$TISCM(RaidLogger.InvalidateReason.RAID_DEFEAT);
        }
    }

    @Inject(method={"setCenter"}, at={@At(value="HEAD")})
    private void raidLogger_onCenterMoved(class_2338 blockPos, CallbackInfo ci) {
        RaidLogger.getInstance().onCenterMoved((class_3765)this, blockPos);
    }
}

