/*
 * Decompiled with CFR 0.152.
 */
package me.I9xn.multipleSessions.Commands;

import java.util.ArrayList;
import java.util.UUID;
import me.I9xn.multipleSessions.MultipleSessions;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CreateSessionCommand
implements CommandExecutor {
    private final MultipleSessions plugin;

    public CreateSessionCommand(MultipleSessions plugin) {
        this.plugin = plugin;
    }

    public boolean createSession(Player p, int session_id) {
        UUID uuid;
        FileConfiguration config = this.plugin.getConfig();
        if (config.contains((uuid = p.getUniqueId()).toString() + "." + session_id)) {
            String msg = config.getString("messages.already-on-session");
            msg = msg.replace("$PREFIX", config.getString("prefix"));
            msg = msg.replace("$CURRENT_SESSION", Integer.toString(session_id));
            p.sendMessage(msg);
            return false;
        }
        Location loc = Bukkit.getWorld((String)"world").getSpawnLocation();
        double pos_x = loc.getX();
        double pos_y = loc.getY();
        double pos_z = loc.getZ();
        String uuid_string = uuid.toString();
        config.set(uuid_string + "." + session_id + ".position.x", (Object)pos_x);
        config.set(uuid_string + "." + session_id + ".position.y", (Object)pos_y);
        config.set(uuid_string + "." + session_id + ".position.z", (Object)pos_z);
        config.set(uuid_string + "." + session_id + ".rotation.yaw", (Object)0);
        config.set(uuid_string + "." + session_id + ".rotation.pitch", (Object)0);
        config.set(uuid_string + "." + session_id + ".inventory", new ArrayList());
        this.plugin.saveConfig();
        String msg = config.getString("messages.created-session");
        msg = msg.replace("$PREFIX", config.getString("prefix"));
        msg = msg.replace("$NEW_SESSION", Integer.toString(session_id));
        p.sendMessage(msg);
        return true;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] args) {
        if (commandSender instanceof Player) {
            if (args.length < 1) {
                commandSender.sendMessage("\u00a7cUsage: /createsession <id>");
                return false;
            }
            if (!this.createSession(((Player)commandSender).getPlayer(), Integer.parseInt(args[0]))) {
                return false;
            }
        }
        return true;
    }
}

