/*
 * Decompiled with CFR 0.152.
 */
package me.I9xn.multipleSessions.Listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.I9xn.multipleSessions.MultipleSessions;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;

public class OnPlayerJoinListener
implements Listener {
    private final MultipleSessions plugin;

    public OnPlayerJoinListener(MultipleSessions plugin) {
        this.plugin = plugin;
    }

    public boolean saveSession(Player p, int session_id, FileConfiguration config, UUID uuid) {
        Location loc = p.getLocation();
        double pos_x = loc.getX();
        double pos_y = loc.getY();
        double pos_z = loc.getZ();
        float rot_yaw = loc.getYaw();
        float rot_pitch = loc.getPitch();
        String uuid_string = uuid.toString();
        ArrayList<String> inventory_items = new ArrayList<String>();
        for (ItemStack item : p.getInventory().getContents()) {
            if (item == null) continue;
            inventory_items.add(item.getType().name());
        }
        config.set(uuid_string + "." + session_id + ".position.x", (Object)pos_x);
        config.set(uuid_string + "." + session_id + ".position.y", (Object)pos_y);
        config.set(uuid_string + "." + session_id + ".position.z", (Object)pos_z);
        config.set(uuid_string + "." + session_id + ".rotation.yaw", (Object)Float.valueOf(rot_yaw));
        config.set(uuid_string + "." + session_id + ".rotation.pitch", (Object)Float.valueOf(rot_pitch));
        config.set(uuid_string + "." + session_id + ".inventory", Arrays.asList(p.getInventory().getContents()));
        this.plugin.saveConfig();
        return true;
    }

    public boolean changeSession(Player p, int session_id, FileConfiguration config) {
        UUID uuid = p.getUniqueId();
        if (config.getInt(uuid.toString() + ".current_session") == session_id) {
            String msg = config.getString("messages.already-on-session");
            msg = msg.replace("$PREFIX", config.getString("prefix"));
            msg = msg.replace("$CURRENT_SESSION", Integer.toString(config.getInt(String.valueOf(uuid) + ".current_session")));
            p.sendMessage(msg);
            return false;
        }
        double pos_x = config.getDouble(String.valueOf(uuid) + "." + session_id + ".position.x");
        double pos_y = config.getDouble(String.valueOf(uuid) + "." + session_id + ".position.y");
        double pos_z = config.getDouble(String.valueOf(uuid) + "." + session_id + ".position.z");
        float rot_yaw = (float)config.getDouble(String.valueOf(uuid) + "." + session_id + ".rotation.yaw");
        float rot_pitch = (float)config.getDouble(String.valueOf(uuid) + "." + session_id + ".rotation.pitch");
        this.saveSession(p, config.getInt(uuid.toString() + ".current_session"), config, uuid);
        p.getInventory().clear();
        List rawList = config.getList(String.valueOf(uuid) + "." + session_id + ".inventory");
        if (rawList != null) {
            ItemStack[] inventory = new ItemStack[rawList.size()];
            for (int i = 0; i < rawList.size(); ++i) {
                Object obj = rawList.get(i);
                inventory[i] = obj instanceof ItemStack ? (ItemStack)obj : null;
            }
            p.getInventory().setContents(inventory);
        }
        Location location = new Location(Bukkit.getWorld((String)"world"), pos_x, pos_y, pos_z);
        p.teleport(location);
        p.setRotation(rot_yaw, rot_pitch);
        config.set(uuid.toString() + ".current_session", (Object)session_id);
        this.plugin.saveConfig();
        String msg = config.getString("messages.switching-session");
        msg = msg.replace("$PREFIX", config.getString("prefix"));
        msg = msg.replace("$NEW_SESSION", Integer.toString(session_id));
        p.sendMessage(msg);
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        FileConfiguration config = this.plugin.getConfig();
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        this.changeSession(p, config.getInt(String.valueOf(uuid) + ".current_session"), config);
    }
}

