/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.block.entity;

import java.util.ArrayList;
import java.util.List;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.component.CurrencyComponent;
import me.villagerunknown.villagercoin.feature.CoinCraftingFeature;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9323;

public abstract class AbstractCurrencyValueBlockEntity
extends class_2586 {
    private Long totalCurrencyValue = 0L;

    public AbstractCurrencyValueBlockEntity(class_2591<? extends AbstractCurrencyValueBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void setTotalCurrencyValue(long value) {
        this.totalCurrencyValue = value;
    }

    public long getTotalCurrencyValue() {
        return this.totalCurrencyValue;
    }

    public boolean canIncrementCurrencyValue(long increment) {
        return this.totalCurrencyValue + increment <= Integer.MAX_VALUE;
    }

    public void incrementCurrencyValue(long value) {
        this.totalCurrencyValue = this.totalCurrencyValue + value;
        this.method_5431();
    }

    public void incrementCurrencyValueAndSetComponent(long value) {
        this.incrementCurrencyValue(value);
        this.method_58684(class_9323.method_57827().method_57840(Villagercoin.CURRENCY_COMPONENT, (Object)new CurrencyComponent(this.getTotalCurrencyValue())).method_57838());
    }

    public boolean canDecrementCurrencyValue(long decrement) {
        return this.totalCurrencyValue - decrement >= 0L;
    }

    public void decrementCurrencyValue(long value) {
        this.totalCurrencyValue = this.totalCurrencyValue - value;
        this.method_5431();
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.totalCurrencyValue = nbt.method_10537("totalCurrencyValue");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10544("totalCurrencyValue", this.totalCurrencyValue.longValue());
        super.method_11007(nbt, registryLookup);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public List<class_1799> getTotalValueAsCoins() {
        ArrayList<class_1799> coinItemStacks = new ArrayList<class_1799>();
        class_1937 world = this.method_10997();
        if (null != world) {
            CurrencyComponent currencyComponent;
            class_1799 coinStack;
            for (long totalValue = this.totalCurrencyValue.longValue(); totalValue > 0L && null != (currencyComponent = (CurrencyComponent)(coinStack = CoinCraftingFeature.getLargestCoin(totalValue, false)).method_57824(Villagercoin.CURRENCY_COMPONENT)); totalValue -= (long)coinStack.method_7947() * currencyComponent.value()) {
                coinItemStacks.add(coinStack);
            }
        }
        return coinItemStacks;
    }

    public void dropTotalValueAsCoins() {
        List<class_1799> coinStacks = this.getTotalValueAsCoins();
        class_1937 world = this.method_10997();
        if (null != world) {
            for (class_1799 coinStack : coinStacks) {
                world.method_8649((class_1297)new class_1542(world, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), coinStack));
            }
        }
    }

    public boolean setBlockEntityCurrencyValue(class_2586 blockEntity, class_1799 itemStack, CurrencyComponent currencyComponent) {
        if (blockEntity instanceof AbstractCurrencyValueBlockEntity) {
            AbstractCurrencyValueBlockEntity coinBankBlockEntity = (AbstractCurrencyValueBlockEntity)blockEntity;
            coinBankBlockEntity.method_58684(itemStack.method_57353());
            coinBankBlockEntity.setTotalCurrencyValue(currencyComponent.value());
            return true;
        }
        return false;
    }

    public boolean incrementBlockEntityCurrencyValue(class_2586 blockEntity, CurrencyComponent currencyComponent) {
        AbstractCurrencyValueBlockEntity coinBankBlockEntity;
        if (blockEntity instanceof AbstractCurrencyValueBlockEntity && (coinBankBlockEntity = (AbstractCurrencyValueBlockEntity)blockEntity).canIncrementCurrencyValue(currencyComponent.value())) {
            coinBankBlockEntity.incrementCurrencyValueAndSetComponent(currencyComponent.value());
            return true;
        }
        return false;
    }
}

