/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.feature;

import java.util.Collection;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.component.CurrencyComponent;
import me.villagerunknown.villagercoin.item.CoinItems;
import me.villagerunknown.villagercoin.recipe.VillagerCoinRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_9694;

public class CoinCraftingFeature {
    private static TreeMap<Long, class_1792> CRAFTING_RESULT_COINS = new TreeMap();
    public static class_1865<VillagerCoinRecipe> RECIPE_SERIALIZER = (class_1865)class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)class_2960.method_60655((String)Villagercoin.MOD_ID, (String)"crafting_special_villager_coin"), (Object)new class_1866(VillagerCoinRecipe::new));

    public static void execute() {
    }

    public static void registerCraftingResultCoin(class_1792 item, long value) {
        CRAFTING_RESULT_COINS.put(value, item);
    }

    public static boolean isCraftingResultCoin(class_1792 item) {
        return CRAFTING_RESULT_COINS.containsValue(item);
    }

    public static boolean canCraftResult(class_1792 item) {
        return item.method_57347().method_57832(Villagercoin.CURRENCY_COMPONENT);
    }

    public static Collection<class_1792> getCraftingResultCoins() {
        return CRAFTING_RESULT_COINS.values();
    }

    public static class_1799 getLargestCoin(long coinValue, boolean singleCount) {
        class_1799 returnStack = class_1799.field_8037;
        class_1792 coin = null;
        for (long value : CRAFTING_RESULT_COINS.keySet()) {
            class_1792 item;
            if (coinValue < value || (item = CRAFTING_RESULT_COINS.get(value)).method_57347().method_57832(Villagercoin.COLLECTABLE_COMPONENT)) continue;
            coin = item;
        }
        if (null != coin) {
            CurrencyComponent currencyComponent = (CurrencyComponent)coin.method_57347().method_57829(Villagercoin.CURRENCY_COMPONENT);
            returnStack = new class_1799(coin, 1);
            if (!singleCount && null != currencyComponent) {
                returnStack = new class_1799((class_1935)coin, CoinCraftingFeature.getConversionValueSafelyFromLong(coinValue, currencyComponent.value()));
            }
        }
        return returnStack;
    }

    public static class_1799 getLargerCoin(long coinValue, boolean singleCount) {
        class_1799 returnStack = class_1799.field_8037;
        class_1792 coin = null;
        for (long value : CRAFTING_RESULT_COINS.keySet()) {
            class_1792 item;
            if (value <= coinValue || (item = CRAFTING_RESULT_COINS.get(value)).method_57347().method_57832(Villagercoin.COLLECTABLE_COMPONENT)) continue;
            coin = item;
            break;
        }
        if (null != coin) {
            CurrencyComponent currencyComponent = (CurrencyComponent)coin.method_57347().method_57829(Villagercoin.CURRENCY_COMPONENT);
            returnStack = new class_1799(coin, CoinCraftingFeature.getConversionValueSafelyFromLong(coinValue, 1L));
            if (!singleCount && null != currencyComponent) {
                returnStack = new class_1799((class_1935)coin, CoinCraftingFeature.getConversionValueSafelyFromLong(coinValue, currencyComponent.value()));
            }
        }
        return returnStack;
    }

    public static class_1799 getSmallerCoin(long coinValue) {
        CurrencyComponent currencyComponent;
        class_1799 returnStack = class_1799.field_8037;
        class_1792 coin = null;
        for (Long value : CRAFTING_RESULT_COINS.keySet()) {
            class_1792 item;
            if (value >= coinValue || (item = CRAFTING_RESULT_COINS.get(value)).method_57347().method_57832(Villagercoin.COLLECTABLE_COMPONENT)) continue;
            coin = item;
        }
        if (null != coin && null != (currencyComponent = (CurrencyComponent)coin.method_57347().method_57829(Villagercoin.CURRENCY_COMPONENT)) && CoinCraftingFeature.getConversionValue(coinValue, currencyComponent.value()) > 1L) {
            returnStack = new class_1799((class_1935)coin, CoinCraftingFeature.getConversionValueSafelyFromLong(coinValue, currencyComponent.value()));
        }
        return returnStack;
    }

    public static class_1799 getSmallestCoin(int coinValue) {
        if (coinValue > 0) {
            return new class_1799((class_1935)CoinItems.COPPER_COIN, coinValue);
        }
        return class_1799.field_8037;
    }

    public static int toIntSafely(long number) {
        try {
            if (number > Integer.MAX_VALUE) {
                number = Integer.MAX_VALUE;
            }
            return Math.toIntExact(number);
        }
        catch (ArithmeticException e) {
            Villagercoin.LOGGER.warn(e.getMessage());
            return 0;
        }
    }

    public static int getConversionValue(int fromValue, int toValue) {
        int result = fromValue > toValue ? fromValue / toValue : toValue / fromValue;
        return result;
    }

    public static long getConversionValue(long fromValue, long toValue) {
        long result = fromValue > toValue ? fromValue / toValue : toValue / fromValue;
        return result;
    }

    public static int getConversionValueSafelyFromLong(long fromValue, long toValue) {
        long result = fromValue > toValue ? fromValue / toValue : toValue / fromValue;
        return CoinCraftingFeature.toIntSafely(result);
    }

    public static TreeMap<Long, CoinIngredient> getCoinIngredientsMap(class_8566 input) {
        class_9694.class_9765 positioned = input.method_60501();
        class_9694 craftingRecipeInput = positioned.comp_2795();
        int left = positioned.comp_2796();
        int top = positioned.comp_2797();
        TreeMap<Long, CoinIngredient> ingredientsMap = new TreeMap<Long, CoinIngredient>(Villagercoin.reverseSortLong);
        for (int y = 0; y < craftingRecipeInput.method_59992(); ++y) {
            for (int x = 0; x < craftingRecipeInput.method_59991(); ++x) {
                int m = x + left + (y + top) * input.method_17398();
                ingredientsMap = CoinCraftingFeature.updateCoinIngredientsMap(ingredientsMap, input.method_5438(m), m, x, y);
            }
        }
        return ingredientsMap;
    }

    public static TreeMap<Long, CoinIngredient> updateCoinIngredientsMap(TreeMap<Long, CoinIngredient> ingredientsMap, class_1799 itemStack, int slot, int x, int y) {
        CurrencyComponent currencyComponent = (CurrencyComponent)itemStack.method_57824(Villagercoin.CURRENCY_COMPONENT);
        if (null != currencyComponent) {
            long currencyValue = currencyComponent.value();
            if (ingredientsMap.containsKey(currencyValue)) {
                currencyValue += (long)ingredientsMap.size();
            }
            ingredientsMap.put(currencyValue, new CoinIngredient(slot, itemStack, y, x));
        }
        return ingredientsMap;
    }

    public static TreeMap<Long, class_1799> updateCoinIngredientsMap(TreeMap<Long, class_1799> ingredientsMap, class_1799 coinItemStack) {
        CurrencyComponent currencyComponent;
        if (!coinItemStack.method_7960() && null != (currencyComponent = (CurrencyComponent)coinItemStack.method_57824(Villagercoin.CURRENCY_COMPONENT))) {
            long currencyValue = currencyComponent.value();
            if (ingredientsMap.containsKey(currencyValue)) {
                currencyValue += (long)ingredientsMap.size();
            }
            ingredientsMap.put(currencyValue, coinItemStack);
        }
        return ingredientsMap;
    }

    public static long subtractCoinValueFromTotalCost(class_1799 ingredient, AtomicLong totalCost, class_8566 craftingInput, int ingredientSlot) {
        CurrencyComponent currencyComponent = (CurrencyComponent)ingredient.method_57824(Villagercoin.CURRENCY_COMPONENT);
        if (null != currencyComponent) {
            long ingredientCoinValue = currencyComponent.value();
            long ingredientCoinStackValue = (long)ingredient.method_7947() * ingredientCoinValue;
            if (ingredientCoinValue == totalCost.get()) {
                craftingInput.method_5434(ingredientSlot, 1);
                totalCost.addAndGet(-ingredientCoinValue);
            } else if (ingredientCoinStackValue <= totalCost.get()) {
                craftingInput.method_5434(ingredientSlot, ingredient.method_7947());
                totalCost.addAndGet(-ingredientCoinStackValue);
            } else if (ingredientCoinValue < totalCost.get()) {
                int amount = CoinCraftingFeature.getConversionValueSafelyFromLong(totalCost.get(), ingredientCoinValue);
                if (amount >= ingredient.method_7947()) {
                    craftingInput.method_5434(ingredientSlot, ingredient.method_7947());
                    totalCost.addAndGet(-(ingredientCoinValue * (long)ingredient.method_7947()));
                } else {
                    craftingInput.method_5434(ingredientSlot, amount);
                    totalCost.addAndGet(-(ingredientCoinValue * (long)amount));
                }
            }
        }
        return totalCost.get();
    }

    public static long subtractCoinValueFromTotalCost(class_1799 ingredient, AtomicLong totalCost, class_2371<class_1799> ingredients) {
        for (class_1799 stack : ingredients) {
            CurrencyComponent currencyComponent;
            if (!stack.equals(ingredient) || null == (currencyComponent = (CurrencyComponent)ingredient.method_57824(Villagercoin.CURRENCY_COMPONENT))) continue;
            long ingredientCoinValue = currencyComponent.value();
            long ingredientCoinStackValue = (long)ingredient.method_7947() * ingredientCoinValue;
            if (ingredientCoinValue == totalCost.get()) {
                stack.method_7934(1);
                totalCost.addAndGet(-ingredientCoinValue);
                continue;
            }
            if (ingredientCoinStackValue <= totalCost.get()) {
                stack.method_7934(ingredient.method_7947());
                totalCost.addAndGet(-ingredientCoinStackValue);
                continue;
            }
            if (ingredientCoinValue >= totalCost.get()) continue;
            int amount = CoinCraftingFeature.getConversionValueSafelyFromLong(totalCost.get(), ingredientCoinValue);
            if (amount >= ingredient.method_7947()) {
                stack.method_7934(ingredient.method_7947());
                totalCost.addAndGet(-(ingredientCoinValue * (long)ingredient.method_7947()));
                continue;
            }
            stack.method_7934(amount);
            totalCost.addAndGet(-(ingredientCoinValue * (long)amount));
        }
        return totalCost.get();
    }

    public static class CoinIngredient {
        public int slot;
        public int y;
        public int x;
        public class_1799 stack;

        public CoinIngredient(int slot, class_1799 stack, int y, int x) {
            this.slot = slot;
            this.y = y;
            this.x = x;
            this.stack = stack;
        }
    }
}

