/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.feature;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.feature.CoinCraftingFeature;
import me.villagerunknown.villagercoin.item.CoinItems;
import me.villagerunknown.villagercoin.recipe.CoinStackRecipe;
import me.villagerunknown.villagercoin.type.CoinType;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_9694;

public class CoinStackCraftingFeature {
    public static class_1792 RECIPE_CARRIER_ITEM = class_1802.field_8276;
    private static HashMap<CoinType, TreeMap<Long, class_1792>> CRAFTING_RESULT_COIN_STACKS = new HashMap(Map.ofEntries(Map.entry(CoinType.COPPER, new TreeMap()), Map.entry(CoinType.IRON, new TreeMap()), Map.entry(CoinType.GOLD, new TreeMap()), Map.entry(CoinType.EMERALD, new TreeMap()), Map.entry(CoinType.NETHERITE, new TreeMap())));
    private static HashSet<class_1792> FLAT_CRAFTING_RESULT_COIN_STACKS = new HashSet();
    public static class_1865<CoinStackRecipe> RECIPE_SERIALIZER = (class_1865)class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)class_2960.method_60655((String)Villagercoin.MOD_ID, (String)"crafting_special_coin_stack"), (Object)new class_1866(CoinStackRecipe::new));

    public static void execute() {
    }

    public static void registerCraftingResultCoinStack(CoinType type, class_2248 block, long value) {
        if (CRAFTING_RESULT_COIN_STACKS.containsKey((Object)type)) {
            TreeMap<Long, class_1792> typeMap = CRAFTING_RESULT_COIN_STACKS.get((Object)type);
            typeMap.put(value, block.method_8389());
            FLAT_CRAFTING_RESULT_COIN_STACKS.add(block.method_8389());
            CRAFTING_RESULT_COIN_STACKS.replace(type, typeMap);
        } else {
            Villagercoin.LOGGER.warn("Attempted to register a Coin Stack crafting result with an invalid type provided.");
        }
    }

    public static boolean isCraftingResultCoinStack(class_1792 item) {
        return FLAT_CRAFTING_RESULT_COIN_STACKS.contains(item);
    }

    public static boolean canCraftResult(class_1792 item) {
        return item.equals(CoinItems.COPPER_COIN) || item.equals(CoinItems.IRON_COIN) || item.equals(CoinItems.GOLD_COIN) || item.equals(CoinItems.EMERALD_COIN) || item.equals(CoinItems.NETHERITE_COIN);
    }

    public static Collection<class_1792> getCraftingResultCoinStacks(CoinType type) {
        if (CRAFTING_RESULT_COIN_STACKS.containsKey((Object)type)) {
            TreeMap<Long, class_1792> typeMap = CRAFTING_RESULT_COIN_STACKS.get((Object)type);
            return typeMap.values();
        }
        return null;
    }

    public static class_1799 getLargestCoinStack(CoinType type, long coinStackValue) {
        class_1799 returnStack = class_1799.field_8037;
        class_1792 coinStack = null;
        if (CRAFTING_RESULT_COIN_STACKS.containsKey((Object)type)) {
            TreeMap<Long, class_1792> typeMap = CRAFTING_RESULT_COIN_STACKS.get((Object)type);
            for (Long value : typeMap.keySet()) {
                class_1792 item;
                if (coinStackValue < value || (item = typeMap.get(value)).method_57347().method_57832(Villagercoin.COLLECTABLE_COMPONENT)) continue;
                coinStack = item;
            }
            if (null != coinStack) {
                returnStack = new class_1799(coinStack, 1);
            }
        }
        return returnStack;
    }

    public static class_1799 getSmallestCoinStack(CoinType type, long coinStackValue) {
        if (coinStackValue > 0L && CRAFTING_RESULT_COIN_STACKS.containsKey((Object)type)) {
            TreeMap<Long, class_1792> typeMap = CRAFTING_RESULT_COIN_STACKS.get((Object)type);
            if (coinStackValue > Integer.MAX_VALUE) {
                coinStackValue = Integer.MAX_VALUE;
            }
            return new class_1799((class_1935)typeMap.get(1L), CoinCraftingFeature.toIntSafely(coinStackValue));
        }
        return class_1799.field_8037;
    }

    public static void subtractCarrierFromIngredients(class_8566 craftingInput, long amount) {
        class_9694.class_9765 positioned = craftingInput.method_60501();
        class_9694 craftingRecipeInput = positioned.comp_2795();
        int left = positioned.comp_2796();
        int top = positioned.comp_2797();
        for (int y = 0; y < craftingRecipeInput.method_59992(); ++y) {
            for (int x = 0; x < craftingRecipeInput.method_59991(); ++x) {
                int m = x + left + (y + top) * craftingInput.method_17398();
                class_1799 ingredientStack = craftingInput.method_5438(m);
                if (!ingredientStack.method_31574(RECIPE_CARRIER_ITEM)) continue;
                if (amount > Integer.MAX_VALUE) {
                    amount = Integer.MAX_VALUE;
                }
                craftingInput.method_5434(m, CoinCraftingFeature.toIntSafely(amount));
            }
        }
    }

    public static void subtractCarrierFromIngredients(class_2371<class_1799> ingredients, int amount) {
        for (class_1799 ingredientStack : ingredients) {
            if (!ingredientStack.method_31574(RECIPE_CARRIER_ITEM)) continue;
            ingredientStack.method_7934(amount);
        }
    }
}

