/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.feature;

import java.util.HashMap;
import java.util.Set;
import me.villagerunknown.platform.util.RegistryUtil;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.data.persistent.PersistentItemExistenceData;
import me.villagerunknown.villagercoin.feature.MobsDropCoinsFeature;
import me.villagerunknown.villagercoin.feature.StructuresIncludeCoinsFeature;
import me.villagerunknown.villagercoin.item.CollectableCoinItem;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class CollectableCoinFeature {
    public static int COPPER_MAXIMUM_IN_CIRCULATION = Villagercoin.CONFIG.copperMaximumCollectables;
    public static int IRON_MAXIMUM_IN_CIRCULATION = Villagercoin.CONFIG.ironMaximumCollectables;
    public static int GOLD_MAXIMUM_IN_CIRCULATION = Villagercoin.CONFIG.goldMaximumCollectables;
    public static int EMERALD_MAXIMUM_IN_CIRCULATION = Villagercoin.CONFIG.emeraldMaximumCollectables;
    public static int NETHERITE_MAXIMUM_IN_CIRCULATION = Villagercoin.CONFIG.netheriteMaximumCollectables;
    public static long COPPER_VALUE = Villagercoin.CONFIG.copperCollectableValue;
    public static long IRON_VALUE = Villagercoin.CONFIG.ironCollectableValue;
    public static long GOLD_VALUE = Villagercoin.CONFIG.goldCollectableValue;
    public static long EMERALD_VALUE = Villagercoin.CONFIG.emeraldCollectableValue;
    public static long NETHERITE_VALUE = Villagercoin.CONFIG.netheriteCollectableValue;
    public static float COPPER_DROP_CHANCE = Villagercoin.CONFIG.copperCollectableDropChance;
    public static float IRON_DROP_CHANCE = Villagercoin.CONFIG.ironCollectableDropChance;
    public static float GOLD_DROP_CHANCE = Villagercoin.CONFIG.goldCollectableDropChance;
    public static float EMERALD_DROP_CHANCE = Villagercoin.CONFIG.emeraldCollectableDropChance;
    public static float NETHERITE_DROP_CHANCE = Villagercoin.CONFIG.netheriteCollectableDropChance;
    private static MinecraftServer server = null;

    public static void execute() {
        CollectableCoinFeature.registerServerStartedEvent();
    }

    public static void registerServerStartedEvent() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CollectableCoinFeature.server = server;
        });
    }

    public static class_1792 registerCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer) {
        return CollectableCoinFeature.registerCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, new class_1792.class_1793());
    }

    public static class_1792 registerCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer, Set<class_5321<class_52>> lootTables, Set<class_1299<?>> entityDrops) {
        return CollectableCoinFeature.registerCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, lootTables, entityDrops, new class_1792.class_1793());
    }

    public static class_1792 registerCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer, class_1792.class_1793 settings) {
        class_1792 item = RegistryUtil.registerItem((String)id, (class_1792)new CollectableCoinItem(settings, value, rarity, 1, 1, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer), (String)Villagercoin.MOD_ID);
        RegistryUtil.addItemToGroup(Villagercoin.ITEM_GROUP_KEY, (class_1792)item);
        return item;
    }

    public static class_1792 registerCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer, Set<class_5321<class_52>> lootTables, Set<class_1299<?>> entityDrops, class_1792.class_1793 settings) {
        class_1792 item = CollectableCoinFeature.registerCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, settings);
        StructuresIncludeCoinsFeature.addCoinToLootTables(item, lootTables);
        MobsDropCoinsFeature.addCoinToMobDrops(item, entityDrops);
        return item;
    }

    public static class_1792 registerCraftableCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer) {
        return CollectableCoinFeature.registerCraftableCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, new class_1792.class_1793());
    }

    public static class_1792 registerCraftableCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer, Set<class_5321<class_52>> lootTables, Set<class_1299<?>> entityDrops) {
        return CollectableCoinFeature.registerCraftableCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, lootTables, entityDrops, new class_1792.class_1793());
    }

    public static class_1792 registerCraftableCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer, class_1792.class_1793 settings) {
        return CollectableCoinFeature.registerCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, settings);
    }

    public static class_1792 registerCraftableCollectableCoinItem(String id, long value, class_1814 rarity, float dropChance, int dropChanceMultiplier, int lootTableWeight, int lootTableRolls, float flipChance, int maximumAllowedInServer, Set<class_5321<class_52>> lootTables, Set<class_1299<?>> entityDrops, class_1792.class_1793 settings) {
        class_1792 item = CollectableCoinFeature.registerCraftableCollectableCoinItem(id, value, rarity, dropChance, dropChanceMultiplier, lootTableWeight, lootTableRolls, flipChance, maximumAllowedInServer, settings);
        StructuresIncludeCoinsFeature.addCoinToLootTables(item, lootTables);
        MobsDropCoinsFeature.addCoinToMobDrops(item, entityDrops);
        return item;
    }

    public static HashMap<class_1792, Integer> getItemsInExistence() {
        if (null != server) {
            PersistentItemExistenceData state = PersistentItemExistenceData.getServerState(server);
            return state.ITEMS_IN_EXISTENCE;
        }
        return new HashMap<class_1792, Integer>();
    }

    public static void setItemsInExistence(HashMap<class_1792, Integer> itemsInExistence) {
        if (null != server) {
            PersistentItemExistenceData state = PersistentItemExistenceData.getServerState(server);
            state.ITEMS_IN_EXISTENCE = itemsInExistence;
        }
    }

    public static int collectablesInCirculation() {
        return CollectableCoinFeature.getItemsInExistence().size();
    }

    public static boolean isInCirculation(class_1792 item) {
        return CollectableCoinFeature.getItemsInExistence().containsKey(item);
    }

    public static boolean canAddToCirculation(class_1792 item, int maximumAllowedInServer) {
        HashMap<class_1792, Integer> itemsInExistence = CollectableCoinFeature.getItemsInExistence();
        if (itemsInExistence.containsKey(item)) {
            return itemsInExistence.get(item) < maximumAllowedInServer;
        }
        return maximumAllowedInServer >= 1;
    }

    public static void addToCirculation(class_1792 item) {
        CollectableCoinFeature.addToCirculation(item, 1);
    }

    public static void addToCirculation(class_1792 item, int amount) {
        HashMap<class_1792, Integer> itemsInExistence = CollectableCoinFeature.getItemsInExistence();
        if (itemsInExistence.containsKey(item)) {
            amount = itemsInExistence.get(item) + amount;
        }
        itemsInExistence.put(item, amount);
        CollectableCoinFeature.setItemsInExistence(itemsInExistence);
    }

    public static void removeFromCirculation(class_1792 item) {
        CollectableCoinFeature.removeFromCirculation(item, 1);
    }

    public static void removeFromCirculation(class_1792 item, boolean maximum) {
        if (maximum) {
            CollectableCoinFeature.removeFromCirculation(item, Integer.MAX_VALUE);
        } else {
            CollectableCoinFeature.removeFromCirculation(item, 1);
        }
    }

    public static void removeFromCirculation(class_1792 item, int amount) {
        HashMap<class_1792, Integer> itemsInExistence = CollectableCoinFeature.getItemsInExistence();
        if (!itemsInExistence.containsKey(item)) {
            return;
        }
        int newAmount = itemsInExistence.get(item) - amount;
        if (newAmount <= 0) {
            itemsInExistence.remove(item);
        } else {
            itemsInExistence.put(item, newAmount);
        }
        CollectableCoinFeature.setItemsInExistence(itemsInExistence);
    }
}

