/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.feature;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.villagerunknown.platform.util.MathUtil;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.feature.CoinCraftingFeature;
import me.villagerunknown.villagercoin.item.CoinItems;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3545;
import net.minecraft.class_9306;

public class MerchantCoinTradingFeature {
    public static Set<class_1792> COPPER_TRADE_ITEMS = new HashSet<class_1792>(Arrays.asList(class_1802.field_8370, class_1802.field_8267, class_1802.field_8577, class_1802.field_8570));
    public static Set<class_1792> IRON_TRADE_ITEMS = new HashSet<class_1792>(Arrays.asList(class_1802.field_19059, class_1802.field_19044, class_1802.field_19056, class_1802.field_19051, class_1802.field_8777, class_1802.field_8108, class_1802.field_8478, class_1802.field_8868, class_1802.field_8864, class_1802.field_8426, class_1802.field_8081, class_1802.field_8178, class_1802.field_17531, class_1802.field_17532, class_1802.field_17520, class_1802.field_17498, class_1802.field_28658, class_1802.field_8054, class_1802.field_28654, class_1802.field_8382, class_1802.field_28655, class_1802.field_8858, class_1802.field_8200, class_1802.field_17539, class_1802.field_17536, class_1802.field_17537, class_1802.field_17535, class_1802.field_42688, class_1802.field_17540, class_1802.field_17538, class_1802.field_37508, class_1802.field_8609, class_1802.field_8699, class_1802.field_8403, class_1802.field_8475, class_1802.field_8371, class_1802.field_8660, class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8313, class_1802.field_8283, class_1802.field_8873, class_1802.field_8218, class_1802.field_8110));
    public static Set<class_1792> GOLD_TRADE_ITEMS = new HashSet<class_1792>(Arrays.asList(class_1802.field_8175, class_1802.field_8598, class_1802.field_8695, class_1802.field_8801, class_1802.field_18674, class_1802.field_20402, class_1802.field_8746, class_1802.field_8634, class_1802.field_8071, class_1802.field_8597, class_1802.field_8801, class_1802.field_8557, class_1802.field_16315, class_1802.field_8087, class_1802.field_8287, class_1802.field_8527, class_1802.field_8250, class_1802.field_8377, class_1802.field_8556, class_1802.field_8802, class_1802.field_8285, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8155, class_1802.field_8790, class_1802.field_8894, class_1802.field_8183));
    public static Set<class_1792> EMERALD_TRADE_ITEMS = new HashSet<class_1792>(Arrays.asList(class_1802.field_8449, class_1802.field_8710, class_1802.field_8233, class_1802.field_8545, class_1802.field_8466, class_1802.field_8833, class_1802.field_8791, class_1802.field_8668, class_1802.field_22019, class_1802.field_22021));
    public static Set<class_1792> NETHERITE_TRADE_ITEMS = new HashSet<class_1792>(Arrays.asList(class_1802.field_22022, class_1802.field_22023, class_1802.field_22024, class_1802.field_22025, class_1802.field_22026, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_41946, class_1802.field_22018, class_1802.field_22020, class_1802.field_22022, class_1802.field_22023, class_1802.field_22024, class_1802.field_22025, class_1802.field_22026));

    public static void execute() {
    }

    public static boolean shouldReplaceTrades(class_9306 firstBuyItem, class_1799 sellItem) {
        return Villagercoin.CONFIG.enableTradeModifications && !CoinCraftingFeature.isCraftingResultCoin(firstBuyItem.comp_2427().method_7909()) && !CoinCraftingFeature.isCraftingResultCoin(sellItem.method_7909());
    }

    public static class_1792 getCoinForTrade(class_9306 firstBuyItem, class_1799 sellItem, int maxUses, boolean rewardingPlayerExperience, int specialPrice, int demandBonus, float priceMultiplier, int merchantExperience) {
        class_1792 coin = CoinItems.COPPER_COIN;
        if (NETHERITE_TRADE_ITEMS.contains(firstBuyItem.comp_2427().method_7909()) || NETHERITE_TRADE_ITEMS.contains(sellItem.method_7909())) {
            coin = CoinItems.NETHERITE_COIN;
        } else if (EMERALD_TRADE_ITEMS.contains(firstBuyItem.comp_2427().method_7909()) || EMERALD_TRADE_ITEMS.contains(sellItem.method_7909())) {
            coin = CoinItems.EMERALD_COIN;
        } else if (merchantExperience >= 20 && (priceMultiplier == 0.2f || maxUses == 3 || sellItem.method_7942()) || sellItem.method_7942() && merchantExperience >= 10 || GOLD_TRADE_ITEMS.contains(firstBuyItem.comp_2427().method_7909()) || GOLD_TRADE_ITEMS.contains(sellItem.method_7909())) {
            coin = CoinItems.GOLD_COIN;
        } else if (merchantExperience > 2 || sellItem.method_7942() || IRON_TRADE_ITEMS.contains(firstBuyItem.comp_2427().method_7909()) || IRON_TRADE_ITEMS.contains(sellItem.method_7909())) {
            coin = CoinItems.IRON_COIN;
        }
        if (COPPER_TRADE_ITEMS.contains(firstBuyItem.comp_2427().method_7909()) || COPPER_TRADE_ITEMS.contains(sellItem.method_7909())) {
            coin = CoinItems.COPPER_COIN;
        }
        return coin;
    }

    public static int getModifiedAmount(int amount, int divisor, int maximum) {
        return Math.clamp((long)(amount / divisor), 1, maximum);
    }

    public static class_9306 replaceEmeraldsInTradedItem(class_9306 tradedItem, class_1792 coin) {
        class_1799 replacedStack = MerchantCoinTradingFeature.replaceEmeraldsInItemStack(tradedItem.comp_2427(), coin);
        return new class_9306((class_1935)replacedStack.method_7909(), replacedStack.method_7947());
    }

    public static class_1799 replaceEmeraldsInItemStack(class_1799 itemStack, class_1792 coin) {
        int amount = itemStack.method_7947();
        if (coin.equals(CoinItems.GOLD_COIN)) {
            amount = MerchantCoinTradingFeature.getModifiedAmount(amount, Villagercoin.CONFIG.goldCoinSellItemDivisor, Villagercoin.CONFIG.goldCoinSellItemMaximum);
        }
        if (itemStack.method_7909().equals(class_1802.field_8687)) {
            itemStack = new class_1799((class_1935)coin, amount);
        }
        return itemStack;
    }

    public static class_3545<class_9306, class_1799> modifyDiamondTrade(class_9306 firstBuyItem, class_1799 sellItem) {
        if (firstBuyItem.comp_2427().method_7909().equals(class_1802.field_8477)) {
            int sellAmount = Villagercoin.CONFIG.goldForDiamond;
            if (MathUtil.hasChance((float)Villagercoin.CONFIG.chanceDiamondBecomesEmeraldTrade)) {
                sellAmount = Villagercoin.CONFIG.goldForEmerald;
                firstBuyItem = new class_9306((class_1935)class_1802.field_8687, firstBuyItem.comp_2427().method_7947());
            }
            sellItem = new class_1799((class_1935)CoinItems.GOLD_COIN, sellAmount);
        }
        return new class_3545((Object)firstBuyItem, (Object)sellItem);
    }

    public static ModifiedTrade modifyTrade(class_9306 firstBuyItem, Optional<class_9306> secondBuyItem, class_1799 sellItem, class_1792 coin) {
        firstBuyItem = MerchantCoinTradingFeature.replaceEmeraldsInTradedItem(firstBuyItem, coin);
        if (secondBuyItem.isPresent()) {
            secondBuyItem = Optional.of(MerchantCoinTradingFeature.replaceEmeraldsInTradedItem(secondBuyItem.get(), coin));
        }
        sellItem = MerchantCoinTradingFeature.replaceEmeraldsInItemStack(sellItem, coin);
        class_3545<class_9306, class_1799> modifiedDiamondTrade = MerchantCoinTradingFeature.modifyDiamondTrade(firstBuyItem, sellItem);
        firstBuyItem = (class_9306)modifiedDiamondTrade.method_15442();
        sellItem = (class_1799)modifiedDiamondTrade.method_15441();
        return new ModifiedTrade(firstBuyItem, secondBuyItem, sellItem);
    }

    public static class ModifiedTrade {
        public class_9306 firstBuyItem;
        public Optional secondBuyItem;
        public class_1799 sellItem;

        public ModifiedTrade(class_9306 firstBuyItem, Optional secondBuyItem, class_1799 sellItem) {
            this.firstBuyItem = firstBuyItem;
            this.secondBuyItem = secondBuyItem;
            this.sellItem = sellItem;
        }
    }
}

