/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.feature;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import me.villagerunknown.platform.util.MathUtil;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.component.CollectableComponent;
import me.villagerunknown.villagercoin.component.DropComponent;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

public class MobsDropCoinsFeature {
    public static final int COPPER_DROP_MINIMUM = Villagercoin.CONFIG.copperDropMinimum;
    public static final int IRON_DROP_MINIMUM = Villagercoin.CONFIG.ironDropMinimum;
    public static final int GOLD_DROP_MINIMUM = Villagercoin.CONFIG.goldDropMinimum;
    public static final int EMERALD_DROP_MINIMUM = Villagercoin.CONFIG.emeraldDropMinimum;
    public static final int NETHERITE_DROP_MINIMUM = Villagercoin.CONFIG.netheriteDropMinimum;
    public static final int COPPER_DROP_MAXIMUM = Villagercoin.CONFIG.copperDropMaximum;
    public static final int IRON_DROP_MAXIMUM = Villagercoin.CONFIG.ironDropMaximum;
    public static final int GOLD_DROP_MAXIMUM = Villagercoin.CONFIG.goldDropMaximum;
    public static final int EMERALD_DROP_MAXIMUM = Villagercoin.CONFIG.emeraldDropMaximum;
    public static final int NETHERITE_DROP_MAXIMUM = Villagercoin.CONFIG.netheriteDropMaximum;
    public static final float COPPER_DROP_CHANCE = Villagercoin.CONFIG.copperDropChance;
    public static final float IRON_DROP_CHANCE = Villagercoin.CONFIG.ironDropChance;
    public static final float GOLD_DROP_CHANCE = Villagercoin.CONFIG.goldDropChance;
    public static final float EMERALD_DROP_CHANCE = Villagercoin.CONFIG.emeraldDropChance;
    public static final float NETHERITE_DROP_CHANCE = Villagercoin.CONFIG.netheriteDropChance;
    public static final int COPPER_DROP_MULTIPLIER = Villagercoin.CONFIG.copperDropMultiplier;
    public static final int IRON_DROP_MULTIPLIER = Villagercoin.CONFIG.ironDropMultiplier;
    public static final int GOLD_DROP_MULTIPLIER = Villagercoin.CONFIG.goldDropMultiplier;
    public static final int EMERALD_DROP_MULTIPLIER = Villagercoin.CONFIG.emeraldDropMultiplier;
    public static final int NETHERITE_DROP_MULTIPLIER = Villagercoin.CONFIG.netheriteDropMultiplier;
    public static Set<class_1299<?>> OPTIONAL_MOB_DROPS = new HashSet<class_1299>(Arrays.asList(class_1299.field_6093, class_1299.field_21973, class_1299.field_23696, class_1299.field_6085, class_1299.field_6115, class_1299.field_6139, class_1299.field_6074, class_1299.field_17714, class_1299.field_6140, class_1299.field_6146, class_1299.field_40116, class_1299.field_16281, class_1299.field_6055, class_1299.field_17943, class_1299.field_6132, class_1299.field_6143, class_1299.field_37419, class_1299.field_30052, class_1299.field_6067, class_1299.field_6057, class_1299.field_6081, class_1299.field_6104, class_1299.field_28315, class_1299.field_6042, class_1299.field_42622, class_1299.field_6113));
    public static Set<class_1299<?>> NETHERITE_MOB_DROPS = new HashSet<class_1299>(Arrays.asList(class_1299.field_6116, class_1299.field_38095, class_1299.field_6119));
    public static Set<class_1299<?>> EMERALD_MOB_DROPS = MobsDropCoinsFeature.combineEntityTypes(NETHERITE_MOB_DROPS, new HashSet<class_1299>(Arrays.asList(class_1299.field_6109)));
    public static Set<class_1299<?>> GOLD_MOB_DROPS = MobsDropCoinsFeature.combineEntityTypes(EMERALD_MOB_DROPS, new HashSet<class_1299>(Arrays.asList(class_1299.field_6086, class_1299.field_6065, class_1299.field_22281, class_1299.field_25751, class_1299.field_6090, class_1299.field_6117, class_1299.field_6076)));
    public static Set<class_1299<?>> IRON_MOB_DROPS = MobsDropCoinsFeature.combineEntityTypes(GOLD_MOB_DROPS, new HashSet<class_1299>(Arrays.asList(class_1299.field_6091, class_1299.field_6105, class_1299.field_49148, class_1299.field_6098, class_1299.field_6145, class_1299.field_6050)));
    public static Set<class_1299<?>> COPPER_MOB_DROPS = MobsDropCoinsFeature.buildCopperMobDrops(new HashSet(Arrays.asList(class_1299.field_6123, class_1299.field_6137, class_1299.field_6077, class_1299.field_17713, class_1299.field_6071, class_1299.field_6051, class_1299.field_6054)));
    public static HashMap<class_1299<?>, Set<class_1792>> MOB_DROPS = new HashMap();

    public static void execute() {
        if (Villagercoin.CONFIG.enableBreedableMobDrops) {
            COPPER_MOB_DROPS = MobsDropCoinsFeature.combineEntityTypes(COPPER_MOB_DROPS, OPTIONAL_MOB_DROPS);
        }
        MobsDropCoinsFeature.registerMobDropsEvent();
    }

    @SafeVarargs
    private static Set<class_1299<?>> combineEntityTypes(Set<class_1299<?>> ... entityTypeCollections) {
        HashSet combinedEntityTypes = new HashSet();
        for (Set<class_1299<?>> entityTypes : entityTypeCollections) {
            combinedEntityTypes.addAll(entityTypes);
        }
        return combinedEntityTypes;
    }

    private static Set<class_1299<?>> buildCopperMobDrops(Set<class_1299<?>> entityTypes) {
        Set<class_1299<?>> copperMobDrops = MobsDropCoinsFeature.combineEntityTypes(IRON_MOB_DROPS, entityTypes);
        if (Villagercoin.CONFIG.enableBreedableMobDrops) {
            copperMobDrops = MobsDropCoinsFeature.combineEntityTypes(copperMobDrops, OPTIONAL_MOB_DROPS);
        }
        return copperMobDrops;
    }

    public static void addCoinToMobDrops(class_1792 coin, Set<class_1299<?>> entityTypes) {
        for (class_1299<?> entityType : entityTypes) {
            if (!MOB_DROPS.containsKey(entityType)) {
                MOB_DROPS.put(entityType, new HashSet());
            }
            Set<class_1792> coins = MOB_DROPS.get(entityType);
            coins.add(coin);
            MOB_DROPS.replace(entityType, coins);
        }
    }

    private static void registerMobDropsEvent() {
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (Villagercoin.CONFIG.addCoinsToMobDrops && null != damageSource && null != damageSource.method_5529() && damageSource.method_5529().method_31747()) {
                HashMap<class_1792, Integer> coinsToDrop = new HashMap<class_1792, Integer>();
                class_1299 entityType = entity.method_5864();
                if (MOB_DROPS.containsKey(entityType)) {
                    Set<class_1792> items = MOB_DROPS.get(entityType);
                    for (class_1792 item : items) {
                        DropComponent dropComponent = (DropComponent)item.method_57347().method_57829(Villagercoin.DROP_COMPONENT);
                        int dropMultiplier = MobsDropCoinsFeature.getDropMultiplier(entityType);
                        if (null != dropComponent) {
                            dropMultiplier = dropComponent.dropChanceMultiplier();
                        }
                        coinsToDrop.put(item, dropMultiplier);
                    }
                }
                MobsDropCoinsFeature.dropCoins(entity, damageSource, coinsToDrop);
            }
        });
    }

    public static void dropCoins(class_1309 entity, class_1282 damageSource, HashMap<class_1792, Integer> coins) {
        class_1799 weapon;
        if (null == damageSource) {
            return;
        }
        class_1937 world = entity.method_37908();
        class_1297 source = damageSource.method_5526();
        float modifier = 1.0f;
        if (null != source && null != (weapon = damageSource.method_60948())) {
            class_1887 lootingEnchantment;
            class_2378 registry;
            class_6880 lootingEntry;
            int enchantmentLevel;
            class_9304 enchantments = class_1890.method_57532((class_1799)weapon);
            class_5455 drm = world.method_30349();
            if (null != drm && (enchantmentLevel = enchantments.method_57536(lootingEntry = (registry = drm.method_30530(class_7924.field_41265)).method_47983((Object)(lootingEnchantment = (class_1887)registry.method_29107(class_1893.field_9110))))) > 0) {
                modifier = 1.0f + Villagercoin.CONFIG.lootingBonusPerLevel * (float)enchantmentLevel;
            }
        }
        float lootingModifier = modifier;
        coins.forEach((coin, multiplier) -> {
            int amount;
            DropComponent dropComponent = (DropComponent)coin.method_57347().method_57829(Villagercoin.DROP_COMPONENT);
            if (null != dropComponent && dropComponent.dropMaximum() > 0 && MathUtil.hasChance((float)(dropComponent.dropChance() * (float)multiplier.intValue() * lootingModifier)) && (amount = (int)MathUtil.getRandomWithinRange((float)dropComponent.dropMinimum(), (float)dropComponent.dropMaximum())) > 0) {
                CollectableComponent collectableComponent = (CollectableComponent)coin.method_57347().method_57829(Villagercoin.COLLECTABLE_COMPONENT);
                if (null != collectableComponent) {
                    if (collectableComponent.canAddToCirculation((class_1792)coin)) {
                        collectableComponent.addToCirculation((class_1792)coin, amount);
                        entity.method_5775(new class_1799((class_1935)coin, amount));
                    }
                } else {
                    entity.method_5775(new class_1799((class_1935)coin, amount));
                }
            }
        });
    }

    public static int getDropMultiplier(class_1299<?> entityType) {
        int dropMultiplier = COPPER_DROP_MULTIPLIER;
        if (NETHERITE_MOB_DROPS.contains(entityType)) {
            dropMultiplier = NETHERITE_DROP_MULTIPLIER;
        } else if (EMERALD_MOB_DROPS.contains(entityType)) {
            dropMultiplier = EMERALD_DROP_MULTIPLIER;
        } else if (GOLD_MOB_DROPS.contains(entityType)) {
            dropMultiplier = GOLD_DROP_MULTIPLIER;
        } else if (IRON_MOB_DROPS.contains(entityType)) {
            dropMultiplier = IRON_DROP_MULTIPLIER;
        }
        return dropMultiplier;
    }
}

