/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.villagercoin.feature;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import me.villagerunknown.platform.util.MathUtil;
import me.villagerunknown.villagercoin.Villagercoin;
import me.villagerunknown.villagercoin.component.CollectableComponent;
import me.villagerunknown.villagercoin.component.DropComponent;
import me.villagerunknown.villagercoin.component.LootTableComponent;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class StructuresIncludeCoinsFeature {
    public static final int COPPER_LOOT_TABLE_ROLLS = Villagercoin.CONFIG.copperLootTableRolls;
    public static final int IRON_LOOT_TABLE_ROLLS = Villagercoin.CONFIG.ironLootTableRolls;
    public static final int GOLD_LOOT_TABLE_ROLLS = Villagercoin.CONFIG.goldLootTableRolls;
    public static final int EMERALD_LOOT_TABLE_ROLLS = Villagercoin.CONFIG.emeraldLootTableRolls;
    public static final int NETHERITE_LOOT_TABLE_ROLLS = Villagercoin.CONFIG.netheriteLootTableRolls;
    public static final int COPPER_LOOT_TABLE_WEIGHT = Villagercoin.CONFIG.copperLootTableWeight;
    public static final int IRON_LOOT_TABLE_WEIGHT = Villagercoin.CONFIG.ironLootTableWeight;
    public static final int GOLD_LOOT_TABLE_WEIGHT = Villagercoin.CONFIG.goldLootTableWeight;
    public static final int EMERALD_LOOT_TABLE_WEIGHT = Villagercoin.CONFIG.emeraldLootTableWeight;
    public static final int NETHERITE_LOOT_TABLE_WEIGHT = Villagercoin.CONFIG.netheriteLootTableWeight;
    public static Set<class_5321<class_52>> NETHERITE_LOOT_TABLES = new HashSet<class_5321>(Arrays.asList(class_39.field_274));
    public static Set<class_5321<class_52>> EMERALD_LOOT_TABLES = NETHERITE_LOOT_TABLES;
    public static Set<class_5321<class_52>> GOLD_LOOT_TABLES = StructuresIncludeCoinsFeature.combineLootTables(EMERALD_LOOT_TABLES, new HashSet<class_5321>(Arrays.asList(class_39.field_24046, class_39.field_24049, class_39.field_24047, class_39.field_24048, class_39.field_803, class_39.field_44649, class_39.field_47423, class_39.field_615, class_39.field_484, class_39.field_38438, class_39.field_49845, class_39.field_50196, class_39.field_49846, class_39.field_50197, class_39.field_50200, class_39.field_47415, class_39.field_50194, class_39.field_50198, class_39.field_274, class_39.field_683, class_39.field_800, class_39.field_842, class_39.field_38439, class_39.field_251)));
    public static Set<class_5321<class_52>> IRON_LOOT_TABLES = StructuresIncludeCoinsFeature.combineLootTables(GOLD_LOOT_TABLES, new HashSet<class_5321>(Arrays.asList(class_39.field_434, class_39.field_17107, class_39.field_17009, class_39.field_850, class_39.field_356, class_39.field_472, class_39.field_662, class_39.field_880, class_39.field_841, class_39.field_49844, class_39.field_50195, class_39.field_19062, class_39.field_19063, class_39.field_19064, class_39.field_19065, class_39.field_19066, class_39.field_19067, class_39.field_19068, class_39.field_19069, class_39.field_19070, class_39.field_19071, class_39.field_19072, class_39.field_19073, class_39.field_19074, class_39.field_854, class_39.field_43353, class_39.field_43354, class_39.field_44648, class_39.field_43356, class_39.field_43357, class_39.field_47426, class_39.field_47416, class_39.field_47417, class_39.field_47418, class_39.field_47419, class_39.field_47420, class_39.field_665, class_39.field_885, class_39.field_397, class_39.field_300, class_39.field_24050, class_39.field_16593)));
    public static Set<class_5321<class_52>> COPPER_LOOT_TABLES = StructuresIncludeCoinsFeature.combineLootTables(IRON_LOOT_TABLES, new HashSet<class_5321>(Arrays.asList(class_39.field_266, class_39.field_16751, class_39.field_17010, class_39.field_17011, class_39.field_17012, class_39.field_17108, class_39.field_18007, class_39.field_16750, class_39.field_17109, class_39.field_16752, class_39.field_16748, class_39.field_16749, class_39.field_16754, class_39.field_16753)));
    public static HashMap<class_5321<class_52>, Set<class_1792>> LOOT_TABLES = new HashMap();

    public static void execute() {
        StructuresIncludeCoinsFeature.registerLootTableEvent();
    }

    @SafeVarargs
    private static Set<class_5321<class_52>> combineLootTables(Set<class_5321<class_52>> ... lootTableCollections) {
        HashSet<class_5321<class_52>> combinedLootTables = new HashSet<class_5321<class_52>>();
        for (Set<class_5321<class_52>> lootTables : lootTableCollections) {
            combinedLootTables.addAll(lootTables);
        }
        return combinedLootTables;
    }

    public static void addCoinToLootTables(class_1792 coin, Set<class_5321<class_52>> lootTables) {
        for (class_5321<class_52> lootTable : lootTables) {
            if (!LOOT_TABLES.containsKey(lootTable)) {
                LOOT_TABLES.put(lootTable, new HashSet());
            }
            Set<class_1792> coins = LOOT_TABLES.get(lootTable);
            coins.add(coin);
            LOOT_TABLES.replace(lootTable, coins);
        }
    }

    private static void registerLootTableEvent() {
        LootTableEvents.MODIFY.register((registryKey, lootBuilder, lootTableSource, registryWrapper) -> {
            if (lootTableSource.isBuiltin() && Villagercoin.CONFIG.addCoinsToStructureLootTables) {
                class_55.class_56 poolBuilder = class_55.method_347();
                if (LOOT_TABLES.containsKey(registryKey)) {
                    Set<class_1792> items = LOOT_TABLES.get(registryKey);
                    for (class_1792 item : items) {
                        LootTableComponent lootTableComponent = (LootTableComponent)item.method_57347().method_57829(Villagercoin.LOOT_TABLE_COMPONENT);
                        if (null == lootTableComponent) continue;
                        CollectableComponent collectableComponent = (CollectableComponent)item.method_57347().method_57829(Villagercoin.COLLECTABLE_COMPONENT);
                        DropComponent dropComponent = (DropComponent)item.method_57347().method_57829(Villagercoin.DROP_COMPONENT);
                        int lootTableWeight = lootTableComponent.lootTableWeight();
                        int lootTableRolls = lootTableComponent.lootTableRolls();
                        if (lootTableWeight <= 0 || lootTableRolls <= 0) continue;
                        if (null != collectableComponent && null != dropComponent) {
                            if (!MathUtil.hasChance((float)(dropComponent.dropChance() * (float)dropComponent.dropChanceMultiplier())) || !collectableComponent.canAddToCirculation(item)) continue;
                            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)item).method_437(lootTableWeight));
                            poolBuilder.method_352((class_5658)class_5662.method_32462((float)lootTableRolls, (float)lootTableRolls));
                            continue;
                        }
                        poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)item).method_437(lootTableWeight));
                        poolBuilder.method_352((class_5658)class_5662.method_32462((float)StructuresIncludeCoinsFeature.getMinimumLootTableRolls(lootTableRolls), (float)lootTableRolls));
                    }
                }
                lootBuilder.method_336(poolBuilder);
            }
        });
    }

    public static int getLootTableWeight(class_5321<class_52> registryKey) {
        int lootTableWeight = COPPER_LOOT_TABLE_WEIGHT;
        if (NETHERITE_LOOT_TABLES.contains(registryKey)) {
            lootTableWeight = NETHERITE_LOOT_TABLE_WEIGHT;
        } else if (EMERALD_LOOT_TABLES.contains(registryKey)) {
            lootTableWeight = EMERALD_LOOT_TABLE_WEIGHT;
        } else if (GOLD_LOOT_TABLES.contains(registryKey)) {
            lootTableWeight = GOLD_LOOT_TABLE_WEIGHT;
        } else if (IRON_LOOT_TABLES.contains(registryKey)) {
            lootTableWeight = IRON_LOOT_TABLE_WEIGHT;
        }
        return lootTableWeight;
    }

    public static int getLootTableRolls(class_5321<class_52> registryKey) {
        int lootTableRolls = COPPER_LOOT_TABLE_ROLLS;
        if (NETHERITE_LOOT_TABLES.contains(registryKey)) {
            lootTableRolls = NETHERITE_LOOT_TABLE_ROLLS;
        } else if (EMERALD_LOOT_TABLES.contains(registryKey)) {
            lootTableRolls = EMERALD_LOOT_TABLE_ROLLS;
        } else if (GOLD_LOOT_TABLES.contains(registryKey)) {
            lootTableRolls = GOLD_LOOT_TABLE_ROLLS;
        } else if (IRON_LOOT_TABLES.contains(registryKey)) {
            lootTableRolls = IRON_LOOT_TABLE_ROLLS;
        }
        return lootTableRolls;
    }

    public static int getMinimumLootTableRolls(int lootTableRolls) {
        lootTableRolls = lootTableRolls > COPPER_LOOT_TABLE_ROLLS ? (lootTableRolls /= COPPER_LOOT_TABLE_ROLLS) : COPPER_LOOT_TABLE_ROLLS / lootTableRolls;
        return lootTableRolls;
    }
}

