/*
 * Decompiled with CFR 0.152.
 */
package me.cocolennon.filteringhoppers;

import me.cocolennon.filteringhoppers.commands.FilteringHoppersCommand;
import me.cocolennon.filteringhoppers.listeners.BlockDropItemListener;
import me.cocolennon.filteringhoppers.listeners.BlockPlaceListener;
import me.cocolennon.filteringhoppers.listeners.EntityDeathListener;
import me.cocolennon.filteringhoppers.listeners.EntityItemDropListener;
import me.cocolennon.filteringhoppers.listeners.InventoryClickListener;
import me.cocolennon.filteringhoppers.listeners.InventoryCloseListener;
import me.cocolennon.filteringhoppers.listeners.InventoryMoveItemListener;
import me.cocolennon.filteringhoppers.listeners.InventoryOpenListener;
import me.cocolennon.filteringhoppers.listeners.PlayerDropItemListener;
import me.cocolennon.filteringhoppers.utils.UpdateChecker;
import me.cocolennon.filteringhoppers.utils.Updater;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private String version;
    private boolean usingOldVersion = false;
    private static Main instance;
    FileConfiguration config = this.getConfig();

    public void onEnable() {
        instance = this;
        this.checkVersion();
        this.setUpConfig();
        this.registerCommandsAndListeners();
        this.getLogger().info("Plugin enabled!");
    }

    private void checkVersion() {
        Updater updater;
        new UpdateChecker(this, 111606).getVersion(cVersion -> {
            this.version = this.getDescription().getVersion();
            if (!this.getVersion().equals(cVersion)) {
                this.getLogger().info("You are using an older version of Filtering Hoppers, please update to version " + cVersion);
                this.usingOldVersion = true;
            }
        });
        if (this.getConfig().getBoolean("auto-updater-enabled") && (updater = new Updater((Plugin)this, 111606, this.getFile(), Updater.UpdateType.VERSION_CHECK, true)).getResult().equals((Object)Updater.Result.SUCCESS)) {
            this.getLogger().info("Update will be applied after next restart!");
        }
    }

    private void setUpConfig() {
        this.config.addDefault("max-hopper-per-chunk", (Object)5);
        this.config.addDefault("chunk-collection-enabled", (Object)true);
        this.config.addDefault("auto-updater-enabled", (Object)true);
        this.config.options().copyDefaults(true);
        this.saveConfig();
    }

    private void registerCommandsAndListeners() {
        this.getCommand("filteringhoppers").setExecutor((CommandExecutor)new FilteringHoppersCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryMoveItemListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryOpenListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryCloseListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDropItemListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockDropItemListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityItemDropListener(), (Plugin)instance);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDeathListener(), (Plugin)instance);
    }

    public String getVersion() {
        return Main.instance.version;
    }

    public boolean getUsingOldVersion() {
        return Main.instance.usingOldVersion;
    }

    public static Main getInstance() {
        return instance;
    }
}

