/*
 * Decompiled with CFR 0.152.
 */
package me.cocolennon.filteringhoppers.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.cocolennon.filteringhoppers.Main;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FilteringHoppersCommand
implements TabExecutor {
    private final List<String> autoComplete = Arrays.asList("info", "reload", "set-max-hopper");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] \u00a7cUsage: /" + label + " </info/reload/set-max-hopper>\n\u00a7c<> = Required.");
            return false;
        }
        switch (args[0]) {
            case "info": {
                this.sendInfo(sender);
                return true;
            }
            case "reload": {
                if (!sender.hasPermission("filteringhoppers.reload")) {
                    sender.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] \u00a7cYou don't have the permission to do that!");
                    return false;
                }
                Main.getInstance().reloadConfig();
                sender.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] Configuration reloaded!");
                return true;
            }
            case "set-max-hopper": {
                if (!sender.hasPermission("filteringhoppers.set-max-hopper")) {
                    sender.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] \u00a7cYou don't have the permission to do that!");
                    return false;
                }
                if (!StringUtils.isNumeric((CharSequence)args[1])) {
                    sender.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] \u00a7cYou must provide a valid number!");
                    return false;
                }
                Main.getInstance().getConfig().set("max-hopper-per-chunk", (Object)Integer.parseInt(args[1]));
                Main.getInstance().saveConfig();
                return true;
            }
        }
        sender.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] \u00a7cUsage: /" + label + " </info/reload/set-max-hopper>\n\u00a7c<> = Required.");
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        if (args.length == 1) {
            return this.autoComplete;
        }
        ArrayList<String> hundred = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            hundred.add(String.valueOf(i));
        }
        if (args.length == 2) {
            return hundred;
        }
        return null;
    }

    private void sendInfo(CommandSender sender) {
        LinkedList<Object> info = new LinkedList<Object>();
        info.add("\u00a7d\u00a7l=========================");
        info.add("\u00a75\u00a7lFiltering Hoppers \u00a75" + ((Main)JavaPlugin.getPlugin(Main.class)).getDescription().getVersion());
        if (Main.getInstance().getUsingOldVersion()) {
            info.add("\u00a7dAn update is available!");
        } else {
            info.add("\u00a75You're using the latest version");
        }
        info.add("\u00a75Made with \u00a7c\u2764 \u00a75by Cocolennon");
        info.add("\u00a7d\u00a7l=========================");
        info.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }
}

