/*
 * Decompiled with CFR 0.152.
 */
package me.cocolennon.filteringhoppers.listeners;

import com.jeff_media.morepersistentdatatypes.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import me.cocolennon.filteringhoppers.Main;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.block.TileState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class EntityDeathListener
implements Listener {
    @EventHandler
    public void entityDeath(EntityDeathEvent event) {
        if (!Main.getInstance().getConfig().getBoolean("chunk-collection-enabled")) {
            return;
        }
        List items = event.getDrops();
        List<TileState> tileStates = EntityDeathListener.getTileStates(event);
        if (tileStates.isEmpty()) {
            return;
        }
        for (TileState current : tileStates) {
            NamespacedKey key;
            PersistentDataContainer container = current.getPersistentDataContainer();
            ItemStack[] arrayFilter = (ItemStack[])container.get(key = new NamespacedKey((Plugin)Main.getInstance(), "hopperFilter"), DataType.ITEM_STACK_ARRAY);
            if (arrayFilter == null) {
                return;
            }
            List<ItemStack> filter = Arrays.asList(arrayFilter);
            boolean filterEmpty = false;
            if (filter == null || filter.isEmpty()) {
                filterEmpty = true;
            }
            Iterator dropIterator = items.iterator();
            while (dropIterator.hasNext()) {
                ItemStack itemStack = (ItemStack)dropIterator.next();
                boolean match = filterEmpty || filter.stream().anyMatch(f -> f.isSimilar(itemStack));
                if (!match) continue;
                try {
                    Hopper hopper = (Hopper)current.getLocation().getBlock().getState();
                    hopper.getSnapshotInventory().addItem(new ItemStack[]{itemStack});
                    dropIterator.remove();
                    hopper.update();
                }
                catch (ClassCastException | ConcurrentModificationException runtimeException) {}
            }
        }
    }

    @NotNull
    private static List<TileState> getTileStates(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Chunk itemLocation = entity.getLocation().getChunk();
        ArrayList<TileState> tileStates = new ArrayList<TileState>();
        for (BlockState current : itemLocation.getTileEntities()) {
            TileState currentTileState;
            if (!(current instanceof TileState) || current.getBlock().getType() != Material.HOPPER || tileStates.contains(currentTileState = (TileState)current)) continue;
            tileStates.add(currentTileState);
        }
        return tileStates;
    }
}

