/*
 * Decompiled with CFR 0.152.
 */
package me.cocolennon.filteringhoppers.utils;

import java.util.List;
import me.cocolennon.filteringhoppers.Main;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Hopper;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MenuCreator {
    private static final MenuCreator instance = new MenuCreator();

    public void createFilterMenu(List<ItemStack> filter, Player player, Block block) {
        Hopper hopper = (Hopper)block.getState();
        Inventory inv = Bukkit.createInventory((InventoryHolder)hopper, (int)27, (String)"\u00a75Filtering Hoppers\u00a7f: \u00a7dFilter Menu");
        if (filter != null) {
            for (ItemStack itemStack : filter) {
                inv.addItem(new ItemStack[]{itemStack});
            }
        }
        this.fillEmpty(inv, this.getItem());
        player.openInventory(inv);
        player.sendMessage("\u00a7d[\u00a75Filtering Hoppers\u00a7d] Successfully opened the filter menu.");
    }

    private void fillEmpty(Inventory inv, ItemStack item) {
        for (int i = 18; i < inv.getSize() && inv.getItem(i) == null; ++i) {
            inv.setItem(i, item);
        }
    }

    public boolean isItemFiller(Inventory inv, int slot) {
        ItemStack item = inv.getItem(slot);
        NamespacedKey buttonAction = new NamespacedKey((Plugin)Main.getInstance(), "buttonAction");
        PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
        return ((String)pdc.get(buttonAction, PersistentDataType.STRING)).equals("filler");
    }

    private ItemStack getItem() {
        ItemStack it = new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1);
        ItemMeta itM = it.getItemMeta();
        assert (itM != null);
        itM.setDisplayName(" ");
        NamespacedKey buttonAction = new NamespacedKey((Plugin)Main.getInstance(), "buttonAction");
        PersistentDataContainer pdc = itM.getPersistentDataContainer();
        pdc.set(buttonAction, PersistentDataType.STRING, (Object)"filler");
        it.setItemMeta(itM);
        return it;
    }

    public int getFirstFreeSlot(Inventory inv) {
        int result = 2001;
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null) continue;
            result = i;
            break;
        }
        return result;
    }

    public static MenuCreator getInstance() {
        return instance;
    }
}

