/*
 * Decompiled with CFR 0.152.
 */
package me.cocolennon.filteringhoppers.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.cocolennon.filteringhoppers.Main;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FilteringHoppersCommand
implements TabExecutor {
    private final List<String> autoComplete = Arrays.asList("info", "reload", "set-max-hopper");
    private MiniMessage miniMessage = Main.getMiniMessage();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(this.miniMessage.deserialize((Object)("<#FF55FF>[<#AA00AA>Filtering Hoppers<#FF55FF>] <#FF5555>Usage: /" + label + " </info/reload/set-max-hopper>\n<#FF5555><> = Required.")));
            return false;
        }
        switch (args[0]) {
            case "info": {
                this.sendInfo(sender);
                return true;
            }
            case "reload": {
                if (!sender.hasPermission("filteringhoppers.reload")) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<#FF55FF>[<#AA00AA>Filtering Hoppers<#FF55FF>] <#FF5555>You don't have the permission to do that!"));
                    return false;
                }
                Main.getInstance().reloadConfig();
                sender.sendMessage(this.miniMessage.deserialize((Object)"<#FF55FF>[<#AA00AA>Filtering Hoppers<#FF55FF>] Configuration reloaded!"));
                return true;
            }
            case "set-max-hopper": {
                if (!sender.hasPermission("filteringhoppers.set-max-hopper")) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<#FF55FF>[<#AA00AA>Filtering Hoppers<#FF55FF>] <#FF5555>You don't have the permission to do that!"));
                    return false;
                }
                if (!StringUtils.isNumeric((CharSequence)args[1])) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<#FF55FF>[<#AA00AA>Filtering Hoppers<#FF55FF>] <#FF5555>You must provide a valid number!"));
                    return false;
                }
                Main.getInstance().getConfig().set("max-hopper-per-chunk", (Object)Integer.parseInt(args[1]));
                Main.getInstance().saveConfig();
                return true;
            }
        }
        sender.sendMessage(this.miniMessage.deserialize((Object)("<#FF55FF>[<#AA00AA>Filtering Hoppers<#FF55FF>] <#FF5555>Usage: /" + label + " </info/reload/set-max-hopper>\n<#FF5555><> = Required.")));
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        if (args.length == 1) {
            return this.autoComplete;
        }
        ArrayList<String> hundred = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            hundred.add(String.valueOf(i));
        }
        if (args.length == 2) {
            return hundred;
        }
        return null;
    }

    private void sendInfo(CommandSender sender) {
        LinkedList<Component> info = new LinkedList<Component>();
        info.add(this.miniMessage.deserialize((Object)"<#FF55FF><bold>========================="));
        info.add(this.miniMessage.deserialize((Object)("<#AA00AA><bold>Filtering Hoppers <#AA00AA>" + ((Main)JavaPlugin.getPlugin(Main.class)).getPluginMeta().getVersion())));
        if (Main.getInstance().getUsingOldVersion()) {
            info.add(this.miniMessage.deserialize((Object)"<#FF55FF>An update is available!"));
        } else {
            info.add(this.miniMessage.deserialize((Object)"<#AA00AA>You're using the latest version"));
        }
        info.add(this.miniMessage.deserialize((Object)"<#AA00AA>Made with <#FF5555>\u2764 <#AA00AA>by Cocolennon"));
        info.add(this.miniMessage.deserialize((Object)"<#FF55FF><bold>========================="));
        info.forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }
}

