/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark;

import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class CustomChatRenderer
implements ChatRenderer {
    private final List<Component> prefixes = new ArrayList<Component>();
    private final List<Component> postFixes = new ArrayList<Component>();
    private String template = "<{0}> {1}";

    public static CustomChatRenderer renderer(AsyncChatEvent event) {
        ChatRenderer chatRenderer = event.renderer();
        if (chatRenderer instanceof CustomChatRenderer) {
            CustomChatRenderer renderer = (CustomChatRenderer)chatRenderer;
            return renderer;
        }
        CustomChatRenderer renderer = new CustomChatRenderer();
        event.renderer((ChatRenderer)renderer);
        return renderer;
    }

    public CustomChatRenderer prefixNearest(ComponentLike comp) {
        this.prefixes.add(comp.asComponent());
        return this;
    }

    public CustomChatRenderer prefix(ComponentLike comp) {
        this.prefixes.add(0, comp.asComponent());
        return this;
    }

    public CustomChatRenderer postfix(ComponentLike comp) {
        this.postFixes.add(comp.asComponent());
        return this;
    }

    public CustomChatRenderer postfixNearest(ComponentLike comp) {
        this.postFixes.add(0, comp.asComponent());
        return this;
    }

    public CustomChatRenderer template(String template) {
        this.template = template;
        return this;
    }

    @NotNull
    public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component message, @NotNull Audience viewer) {
        TextComponent.Builder builder = Component.text();
        for (Component c : this.prefixes) {
            builder.append(c);
        }
        builder.append(TextBuilder.buildComponent((String)this.template, (Component[])new Component[]{sourceDisplayName, message}));
        for (Component c : this.postFixes) {
            builder.append(c);
        }
        return builder.build();
    }
}

