/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.automatic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.APIProfile;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;

@QuarkModule(version="1.0.0", beta=true, compatBlackList={APIProfile.FOLIA})
@CommandProvider(value={SaveWorldCommand.class})
public final class AutoSave
extends PackageModule
implements Runnable {
    private final Map<World, Boolean> worlds = new HashMap<World, Boolean>();

    public void enable() {
        this.worlds.clear();
        ConfigEntry config = this.getConfig();
        for (String id : config.value("worlds").list(String.class)) {
            World world = Bukkit.getWorld((String)id);
            if (world == null) continue;
            this.worlds.put(world, world.isAutoSave());
            world.setAutoSave(false);
        }
        int delay = config.value("delay").intValue();
        int period = config.value("period").intValue();
        TaskService.global().timer("quark://auto_save/timer", (long)delay, (long)period, (Runnable)this);
    }

    public void disable() {
        TaskService.global().cancel("quark://auto_save/timer");
        for (World world : this.worlds.keySet()) {
            world.setAutoSave(this.worlds.get(world).booleanValue());
        }
    }

    private void broadcast(World world, String msgId) {
        if (this.getConfig().value("silent").bool()) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getWorld() != world || this.getConfig().value("broadcast-op-only").bool() && !p.isOp()) continue;
            this.getLanguage().item(msgId).send((Object)p, new Object[]{world.getName()});
        }
    }

    public void saveWorld(World world) {
        this.broadcast(world, "restart");
        world.save();
        this.broadcast(world, "finish");
    }

    @Override
    public void run() {
        for (World world : this.worlds.keySet()) {
            this.saveWorld(world);
        }
    }

    @QuarkCommand(name="save-world")
    public static final class SaveWorldCommand
    extends ModuleCommand<AutoSave> {
        public void onCommand(CommandSender sender, String[] args) {
            if (Objects.equals(args[0], "all")) {
                this.getLanguage().item("command").send((Object)sender, new Object[0]);
                for (World w : Bukkit.getWorlds()) {
                    ((AutoSave)this.getModule()).saveWorld(w);
                }
                return;
            }
            ((AutoSave)this.getModule()).saveWorld(Bukkit.getWorld((String)args[0]));
            this.getLanguage().item("command").send((Object)sender, new Object[0]);
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length != 1) {
                return;
            }
            for (World w : Bukkit.getWorlds()) {
                tabList.add(w.getName());
            }
            tabList.add("all");
        }
    }
}

