/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.automatic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0")
@CommandProvider(value={CleanCommand.class})
public final class GarbageCleaner
extends PackageModule
implements Runnable {
    private static final int[] REMAIN = new int[]{120, 60, 30, 20, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private final Set<Cleaner> cleaners = new HashSet<Cleaner>(4);
    private List<String> whitelistedWorlds;

    public void enable() {
        ConfigEntry config = this.getConfig();
        this.whitelistedWorlds = config.value("world-whitelist").list(String.class);
        this.cleaners.clear();
        if (ConfigAccessor.getBool((ConfigEntry)config, (String)"clean-drops")) {
            boolean b1 = ConfigAccessor.getBool((ConfigEntry)config, (String)"ignore-enchant-item");
            this.addCleaner(new DropCleaner(config.value("item-whitelist").list(String.class), b1));
        }
        if (ConfigAccessor.getBool((ConfigEntry)config, (String)"clean-dense-entity")) {
            this.addCleaner(new DenseEntityCleaner(ConfigAccessor.getInt((ConfigEntry)config, (String)"dense-entity-max-count")));
        }
        TaskService.async().timer("cleaner::timer", 0L, (long)ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"clean-interval"), (Runnable)this);
    }

    public void disable() {
        TaskService.async().cancel("cleaner::timer");
    }

    private void addCleaner(Cleaner c) {
        if (this.cleaners.contains(c)) {
            return;
        }
        this.cleaners.add(c);
    }

    @Override
    public void run() {
        this.submit();
    }

    public void submit() {
        for (int i : REMAIN) {
            TaskService.async().delay((long)((120 - i) * 20), (Runnable)new WarningCallback(i, this.getLanguage()));
        }
        TaskService.global().delay(2400L, this.cleanTask());
    }

    private Runnable cleanTask() {
        return () -> {
            MessageAccessor.broadcast((LanguageEntry)this.getLanguage(), (boolean)false, (boolean)false, (String)"restart", (Object[])new Object[0]);
            for (World world : Bukkit.getWorlds()) {
                if (this.whitelistedWorlds.contains(world.getName())) continue;
                for (Cleaner cleaner : this.cleaners) {
                    cleaner.clean(world);
                }
            }
            MessageAccessor.broadcast((LanguageEntry)this.getLanguage(), (boolean)false, (boolean)false, (String)"complete", (Object[])new Object[0]);
        };
    }

    private static final class DropCleaner
    extends Cleaner {
        private final List<String> whiteList;
        private final boolean ignoreEnchanted;

        DropCleaner(List<String> whiteList, boolean ignoreEnchanted) {
            this.whiteList = whiteList;
            this.ignoreEnchanted = ignoreEnchanted;
        }

        @Override
        public void clean(World world) {
            for (Entity e : world.getEntities()) {
                Item item;
                String type;
                if (!(e instanceof Item) || this.whiteList.contains(type = (item = (Item)e).getItemStack().getType().getKey().getKey()) || this.ignoreEnchanted && !item.getItemStack().getEnchantments().isEmpty()) continue;
                e.remove();
            }
        }
    }

    private static abstract class Cleaner {
        private Cleaner() {
        }

        public abstract void clean(World var1);

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.getClass().getName();
        }

        public boolean equals(Object obj) {
            return this.getClass().isInstance(obj);
        }
    }

    private static final class DenseEntityCleaner
    extends Cleaner {
        private final int maxCount;

        DenseEntityCleaner(int maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public void clean(World world) {
            for (Chunk chunk : world.getLoadedChunks()) {
                HashMap<EntityType, Integer> map = new HashMap<EntityType, Integer>();
                for (Entity entity : chunk.getEntities()) {
                    if (entity instanceof Item || entity instanceof Player) continue;
                    EntityType type = entity.getType();
                    int count = map.getOrDefault(type, 0);
                    if (count > this.maxCount) {
                        entity.remove();
                        map.put(type, count);
                        continue;
                    }
                    map.put(type, count + 1);
                }
            }
        }
    }

    private static final class WarningCallback
    implements Runnable {
        private final int remain;
        private final LanguageEntry entry;

        private WarningCallback(int remain, LanguageEntry entry) {
            this.remain = remain;
            this.entry = entry;
        }

        @Override
        public void run() {
            this.entry.item("remain").broadcast(false, false, new Object[]{this.remain});
        }
    }

    @QuarkCommand(name="clean", op=true)
    public static final class CleanCommand
    extends ModuleCommand<GarbageCleaner> {
        public void onCommand(CommandSender sender, String[] args) {
            switch (args[0]) {
                case "now": {
                    ((GarbageCleaner)this.getModule()).cleanTask().run();
                    break;
                }
                case "schedule": {
                    ((GarbageCleaner)this.getModule()).submit();
                }
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length != 1) {
                return;
            }
            tabList.add("now");
            tabList.add("schedule");
        }
    }
}

