/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.automatic;

import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@CommandProvider(value={GCCommand.class})
@QuarkModule(version="1.3.0")
public final class VMGarbageCleaner
extends PackageModule {
    public static final String GC_TASK_TID = "quark:auto_gc:gc";
    @Inject
    private LanguageEntry language;

    public void enable() {
        int period = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"period");
        TaskService.async().timer(GC_TASK_TID, (long)period, (long)period, this::gc);
    }

    public void disable() {
        TaskService.async().cancel(GC_TASK_TID);
    }

    public void gc() {
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"broadcast")) {
            MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)true, (boolean)false, (String)"gc-start", (Object[])new Object[0]);
        }
        long prev = Runtime.getRuntime().freeMemory();
        System.gc();
        long now = Runtime.getRuntime().freeMemory();
        long collect = (now - prev) / 0x100000L;
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"broadcast")) {
            MessageAccessor.broadcast((LanguageEntry)this.language, (boolean)true, (boolean)false, (String)"gc-end", (Object[])new Object[]{collect});
        }
    }

    public void manualGC(CommandSender sender) {
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"gc-start", (Object[])new Object[0]);
        long prev = Runtime.getRuntime().freeMemory();
        System.gc();
        long now = Runtime.getRuntime().freeMemory();
        long collect = (now - prev) / 0x100000L;
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"gc-end", (Object[])new Object[]{collect});
    }

    @QuarkCommand(name="gc", permission="-quark.gc.command")
    public static final class GCCommand
    extends ModuleCommand<VMGarbageCleaner> {
        public void onCommand(CommandSender sender, String[] args) {
            ((VMGarbageCleaner)this.getModule()).manualGC(sender);
        }
    }
}

