/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import java.util.HashSet;
import java.util.Objects;
import me.gb2022.commons.reflect.AutoRegister;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;

@AutoRegister(value={"qb:el"})
@QuarkModule(id="chat-at", version="1.2")
public final class ChatAt
extends PackageModule {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Players.addChatTabOption((Player)player, (String[])new String[]{"@" + event.getPlayer().getName()});
            Players.addChatTabOption((Player)event.getPlayer(), (String[])new String[]{"@" + player.getName()});
        }
        Players.addChatTabOption((Player)event.getPlayer(), (String[])new String[]{"@all"});
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Players.removeChatTabOption((Player)player, (String[])new String[]{"@" + event.getPlayer().getName()});
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        ConfigEntry cfg = this.getConfig();
        String msg = event.getMessage();
        StringBuilder titleBuilder = new StringBuilder();
        StringBuilder msgBuilder = new StringBuilder();
        HashSet<String> targets = new HashSet<String>();
        for (String column : msg.split(" ")) {
            if (!column.startsWith("@")) {
                titleBuilder.append(column).append(" ");
                msgBuilder.append(column).append(" ");
                continue;
            }
            if (column.equals("@all")) {
                msgBuilder.append(this.generateAtMessage("all")).append(" ");
                for (Player p : Bukkit.getOnlinePlayers()) {
                    targets.add(p.getName());
                }
                continue;
            }
            Player p = Bukkit.getPlayerExact((String)column.replaceFirst("@", ""));
            if (!Bukkit.getOnlinePlayers().contains(p) || p == null) continue;
            msgBuilder.append(this.generateAtMessage(column)).append(" ");
            targets.add(p.getName());
        }
        event.setMessage(msgBuilder.toString());
        targets.remove(event.getPlayer().getName());
        for (String s : targets) {
            Player p = Bukkit.getPlayerExact((String)s);
            if (p == null) continue;
            TextSender.subtitle((Player)p, (ComponentLike)TextBuilder.buildComponent((String)this.generateTitleMessage(titleBuilder.toString(), event.getPlayer()), (Component[])new Component[0]), (int)cfg.value("title-fadein").intValue(), (int)cfg.value("title-stay").intValue(), (int)cfg.value("title-fadeout").intValue());
            if (!cfg.value("sound").bool()) continue;
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.0f);
        }
    }

    public String generateAtMessage(String column) {
        ConfigEntry cfg = this.getConfig();
        String target = column.replaceFirst("@", "");
        String completedTemplate = cfg.value("at-template").string().replace("{player}", target);
        return PlaceHolderService.format((String)completedTemplate);
    }

    public String generateTitleMessage(String msg, Player p) {
        ConfigEntry cfg = this.getConfig();
        String template = Objects.requireNonNull(cfg.value("at-title-template").string());
        String completedTemplate = template.replace("{player}", p.getName()).replace("{message}", msg);
        return PlaceHolderService.format((String)completedTemplate);
    }
}

