/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleO2;
import me.gb2022.commons.reflect.method.MethodHandleRO1;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.atcraftmc.qlib.command.LegacyCommandManager;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.atcraftmc.qlib.texts.placeholder.GloballyPlaceHolder;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.foundation.ComponentSerializer;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.APIProfileTest;
import org.tbstcraft.quark.foundation.platform.BukkitDataAccess;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolders;

@AutoRegister(value={"qb:el"})
@Components(value={PaperChatListener.class, PaperSignChangeListener.class})
@QuarkModule(id="chat-component", version="1.3.0")
public final class ChatComponent
extends PackageModule {
    GloballyPlaceHolder chat = PlaceHolders.chat();
    @Inject(value="tip")
    private LanguageItem tip;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
    }

    @EventHandler
    public void onChatting(AsyncPlayerChatEvent event) {
        if (APIProfileTest.isPaperCompat()) {
            return;
        }
        String msg = event.getMessage();
        msg = PlaceHolderService.format((String)msg);
        msg = PlaceHolderService.formatPlayer((Player)event.getPlayer(), (String)msg);
        msg = this.processChar(msg);
        msg = this.processColorChars(msg);
        event.setMessage(TextBuilder.build((String)msg, (boolean)true, (Component[])new Component[0]).toString());
    }

    @EventHandler
    public void onCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (LegacyCommandManager.isQLibCommand((String)event.getMessage().split(" ")[0].replace("/", ""))) {
            return;
        }
        if (event.getMessage().contains("self-msg")) {
            return;
        }
        String msg = event.getMessage();
        msg = PlaceHolderService.format((String)msg);
        msg = this.processChar(msg);
        msg = this.processColorChars(msg);
        event.setMessage(TextBuilder.build((String)msg, (boolean)false, (Component[])new Component[0]).toString());
    }

    public String processChar(String input) {
        StringBuilder output = new StringBuilder();
        int processedIndex = 0;
        int cap = input.length();
        for (int i = 0; i < cap; ++i) {
            char current = input.charAt(i);
            if (i < processedIndex) continue;
            if (current != '\\') {
                ++processedIndex;
                output.append(current);
                continue;
            }
            if (cap - i < 2) {
                ++processedIndex;
                output.append(current);
                continue;
            }
            char next = input.charAt(i + 1);
            if (next != 'u') {
                processedIndex += 2;
                switch (next) {
                    case 'n': {
                        output.append('\n');
                        break;
                    }
                    case 't': {
                        output.append('\t');
                        break;
                    }
                    case 'r': {
                        output.append('\r');
                        break;
                    }
                    case 'b': {
                        output.append('\b');
                        break;
                    }
                    case 'f': {
                        output.append('\f');
                        break;
                    }
                    case '\'': {
                        output.append('\'');
                        break;
                    }
                    case '\"': {
                        output.append('\"');
                        break;
                    }
                    default: {
                        output.append('\\');
                        break;
                    }
                }
                continue;
            }
            processedIndex += 6;
            String sequence = input.substring(i + 2, i + 6);
            output.append((char)Integer.parseInt(sequence, 16));
        }
        return output.toString();
    }

    public String processColorChars(String input) {
        for (String s : this.chat.getRegisterKeys()) {
            input = input.replace(s, this.chat.get(s));
        }
        return input;
    }

    @AutoRegister(value={"qb:el"})
    public static final class PaperChatListener
    extends ModuleComponent<ChatComponent> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("io.papermc.paper.event.player.AsyncChatEvent"));
        }

        @EventHandler
        public void onChatting(AsyncChatEvent event) {
            String msg = LegacyComponentSerializer.legacySection().serialize(event.message());
            msg = ((ChatComponent)this.parent).processColorChars(msg);
            msg = PlaceHolderService.format((String)msg);
            msg = PlaceHolderService.formatPlayer((Player)event.getPlayer(), (String)msg);
            msg = ((ChatComponent)this.parent).processChar(msg);
            event.message(TextBuilder.buildComponent((String)msg, (boolean)true, (Component[])new Component[0]));
        }

        @EventHandler
        public void onAnvilRename(PrepareAnvilEvent event) {
            AnvilInventory anvilInventory = event.getInventory();
            ItemStack resultItem = event.getResult();
            if (resultItem == null) {
                return;
            }
            String renameText = anvilInventory.getRenameText();
            if (renameText == null || renameText.isEmpty()) {
                return;
            }
            BukkitDataAccess.itemMeta((ItemStack)resultItem, meta -> {
                String msg = renameText;
                msg = ((ChatComponent)this.parent).processColorChars(msg);
                msg = PlaceHolderService.format((String)msg);
                msg = PlaceHolderService.formatPlayer((Player)((Player)event.getViewers().get(0)), (String)msg);
                msg = ((ChatComponent)this.parent).processChar(msg);
                meta.displayName(TextBuilder.buildComponent((String)msg, (boolean)false, (Component[])new Component[0]));
            });
        }
    }

    @AutoRegister(value={"qb:el"})
    public static final class PaperSignChangeListener
    extends ModuleComponent<ChatComponent> {
        private MethodHandleO2<SignChangeEvent, Integer, Component> setLine;
        private MethodHandleRO1<SignChangeEvent, String, Integer> getLine;

        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("org.bukkit.event.block.SignChangeEvent"));
        }

        public void enable() {
            Class<SignChangeEvent> t = SignChangeEvent.class;
            this.setLine = (MethodHandleO2)MethodHandle.select(ctx -> {
                ctx.attempt(() -> t.getMethod("line", Integer.TYPE, Component.class), (o, i, c) -> o.line(i.intValue(), c));
                ctx.dummy((o, i, c) -> o.setLine(i.intValue(), ComponentSerializer.legacy((ComponentLike)c)));
            });
            this.getLine = (MethodHandleRO1)MethodHandle.select(ctx -> {
                ctx.attempt(() -> t.getMethod("line", Integer.TYPE), (o, i) -> ComponentSerializer.legacy((ComponentLike)((ComponentLike)Objects.requireNonNullElse(o.line(i.intValue()), Component.text((String)"")))));
                ctx.dummy((o, i) -> o.getLine(i.intValue()));
            });
        }

        @EventHandler
        public void onSignEdit(SignChangeEvent event) {
            for (int i = 0; i < event.lines().size(); ++i) {
                String text = (String)this.getLine.invoke((Object)event, (Object)i);
                text = ((ChatComponent)this.parent).processColorChars(text);
                text = ((ChatComponent)this.parent).processChar(text);
                Matcher matcher = Pattern.compile("\u00a7.").matcher(text);
                while (matcher.find()) {
                    String res = matcher.group();
                    text = text.replace(res, "{#&" + res.substring(1) + "}");
                }
                this.setLine.invoke((Object)event, (Object)i, (Object)TextBuilder.buildComponent((String)text, (boolean)false, (Component[])new Component[0]));
            }
        }
    }
}

