/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.quark.chat.ChatReport;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.CachedInfo;

@AutoRegister(value={"qb:el"})
@QuarkModule(id="chat-filter", version="1.0.0")
@QuarkCommand(name="chat-filter", permission="-quark.config.chatfilter")
public final class ChatFilter
extends CommandModule {
    private final Set<Pattern> patterns = new HashSet<Pattern>();
    private final Set<String> flagged = new HashSet<String>();
    @Inject
    private LanguageEntry language;
    @Inject(value="chat-filter;false")
    private AssetGroup rules;

    public static CheckResult filter(String msg, boolean cover, char coverChar, Set<Pattern> pattern) {
        String coverSource = String.valueOf(coverChar);
        StringBuilder buf = new StringBuilder();
        StringBuilder res = new StringBuilder();
        HashSet<String> keywords = new HashSet<String>();
        for (char c : msg.toCharArray()) {
            if (c == '\ufffb') {
                res.append((CharSequence)buf);
                buf.delete(0, buf.length());
                continue;
            }
            if (c != '\ufffa') {
                buf.append(c);
                continue;
            }
            String block = buf.toString();
            buf.delete(0, buf.length());
            for (Pattern p : pattern) {
                Matcher m = p.matcher(block);
                while (m.find()) {
                    String match = m.group();
                    keywords.add(match);
                    if (!cover) continue;
                    block = block.replace(match, coverSource.repeat(match.length()));
                }
            }
            res.append(block);
        }
        return new CheckResult(keywords, msg.replace("\ufffa", "").replace("\ufffb", ""), res.toString());
    }

    public void enable() {
        super.enable();
        this.load();
    }

    public void load() {
        this.patterns.clear();
        if (!this.rules.existFolder()) {
            this.rules.save("default-rule.txt");
            this.rules.save("default-rule.split.txt");
        }
        for (String s : this.rules.list()) {
            String exp = this.rules.asText(s).replace("\n", "");
            if (s.endsWith(".split.txt")) {
                String[] parts = exp.split("#");
                StringBuilder regexBuilder = new StringBuilder();
                for (String part : parts) {
                    String p;
                    if (part.isEmpty() || (p = part.replace("+", "")).isEmpty() || p.isBlank()) continue;
                    regexBuilder.append(p).append("+").append("|");
                }
                regexBuilder.deleteCharAt(regexBuilder.length() - 1);
                exp = regexBuilder.toString();
            }
            this.patterns.add(Pattern.compile(exp));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void handle(AsyncPlayerChatEvent event) {
        event.setMessage(this.process(event.getMessage()));
    }

    @EventHandler
    public void handle(PlayerCommandPreprocessEvent event) {
        List commands = ConfigAccessor.configList((ConfigEntry)this.getConfig(), (String)"handled-commands", String.class);
        boolean process = false;
        for (String c : commands) {
            if (!event.getMessage().startsWith("/" + c)) continue;
            process = true;
            break;
        }
        if (!process) {
            return;
        }
        event.setMessage(this.process(event.getMessage()));
    }

    @EventHandler
    public void onChatReported(ChatReport.ChatReportedEvent event) {
        if (this.flagged.contains(event.getUuid())) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)Bukkit.getPlayerExact((String)event.getSender()), (String)"reported-warn", (Object[])new Object[]{event.getShorted()});
            if (!ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"punish")) {
                event.setOutcome(this.language.item("outcome-warn"));
                return;
            }
            String command = this.getConfig().value("punish-command").string().replace("{player}", event.getSender());
            TaskService.global().run(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
            event.setOutcome(this.language.item("outcome-punished"));
        }
    }

    public void onCommand(CommandSender sender, String[] args) {
        switch (args[0]) {
            case "reload": {
                this.load();
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"reload", (Object[])new Object[0]);
                break;
            }
            case "save": {
                this.rules.save("default-rule.txt");
                this.rules.save("default-rule.split.txt");
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"save", (Object[])new Object[0]);
            }
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.add("reload");
            tabList.add("save");
        }
    }

    public String process(String msg) {
        boolean exceptPlayer = this.getConfig().value("except-player").bool();
        boolean cover = this.getConfig().value("cover").bool();
        char coverChar = this.getConfig().value("cover-char").string().charAt(0);
        msg = ((String)msg).replace("\ufffa", "").replace("\ufffb", "");
        if (exceptPlayer) {
            for (String name : CachedInfo.getAllPlayerNames()) {
                msg = ((String)msg).replaceAll("(?<!\ufffa[^\ufffb])" + name + "+(?![^\ufffa]*?\ufffb)", "\ufffa" + name + "\ufffb");
            }
            msg = "\ufffb" + (String)msg + "\ufffa";
        }
        CheckResult result = ChatFilter.filter((String)msg, cover, coverChar, this.patterns);
        String out = result.processed();
        if (result.flagged()) {
            this.flagged.add(ChatReport.hash(out));
        }
        return out;
    }

    public record CheckResult(Set<String> matched, String origin, String processed) {
        public boolean flagged() {
            return !this.matched.isEmpty();
        }
    }
}

