/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.framework.event.CustomEvent;
import org.tbstcraft.quark.framework.event.QuarkEvent;
import org.tbstcraft.quark.framework.service.QuarkService;
import org.tbstcraft.quark.framework.service.Service;
import org.tbstcraft.quark.framework.service.ServiceInject;

@QuarkService(id="chat-forwarding", requiredBy={"quark-base:"})
public interface ChatForwardingService
extends Service {
    public static final Listener EVENT_HANDLER = ChatForwardingService.createImplementation();

    @ServiceInject
    public static void start() {
        BukkitUtil.registerEventListener((Listener)EVENT_HANDLER);
    }

    @ServiceInject
    public static void stop() {
        BukkitUtil.unregisterEventListener((Listener)EVENT_HANDLER);
    }

    public static Listener createImplementation() {
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            return new PaperEventHandler();
        }
        catch (Throwable ignored) {
            return new BukkitEventHandler();
        }
    }

    public static class PaperEventHandler
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onChatting(AsyncChatEvent event) {
            event.setCancelled(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                Component msg = event.renderer().render(event.getPlayer(), event.getPlayer().displayName(), event.message(), (Audience)player);
                ChatForwardingEvent e = new ChatForwardingEvent(player, event.getPlayer(), msg);
                Bukkit.getPluginManager().callEvent((Event)e);
                if (e.isCancelled()) continue;
                TextSender.sendMessage((CommandSender)player, (ComponentLike)e.getExamined());
            }
        }
    }

    public static class BukkitEventHandler
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onChatting(AsyncPlayerChatEvent event) {
            event.setCancelled(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                String msg = event.getFormat().formatted(event.getPlayer(), event.getMessage());
                ChatForwardingEvent e = new ChatForwardingEvent(player, event.getPlayer(), (Component)Component.text((String)msg));
                Bukkit.getPluginManager().callEvent((Event)e);
                if (e.isCancelled()) continue;
                TextSender.sendMessage((CommandSender)player, (ComponentLike)e.getExamined());
            }
        }
    }

    @QuarkEvent
    public static final class ChatForwardingEvent
    extends CustomEvent
    implements Cancellable {
        private final Player sender;
        private final Player viewer;
        private final Component previous;
        private Component examined;
        private boolean cancelled;

        public ChatForwardingEvent(Player sender, Player viewer, Component previous) {
            this.sender = sender;
            this.viewer = viewer;
            this.previous = previous;
            this.examined = previous;
        }

        public static HandlerList getHandlerList() {
            return ChatForwardingEvent.getHandlerList(ChatForwardingEvent.class);
        }

        public Player getSender() {
            return this.sender;
        }

        public Player getViewer() {
            return this.viewer;
        }

        public Component getExamined() {
            return this.examined;
        }

        public void setExamined(Component examined) {
            this.examined = examined;
        }

        public Component getPrevious() {
            return this.previous;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }
}

