/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import me.gb2022.commons.http.HttpMethod;
import me.gb2022.commons.http.HttpRequest;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.bukkit.command.CommandSender;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkCommand(name="chatgpt", permission="+quark.chatgpt")
@QuarkModule
public final class ChatGPT
extends CommandModule {
    public static final String GPT35 = "api.alcex.cn/API/gpt-3.5/";
    public static final String GPT40 = "api.alcex.cn/API/gpt-4/";
    public static final String PROMPT = "(\u8bf7\u4f7f\u7528\u5c3d\u91cf\u7b80\u77ed\u7684\u6587\u5b57\u56de\u7b54,\u7ed9\u51fa\u7684\u6587\u5b57\u4e2d\u5c06\u7528\u201c$$\u201d\u4ee3\u8868\u4e00\u4e2a\u7a7a\u683c,\u8bf7\u4f7f\u7528\u7eaf\u6587\u672c\u56de\u7b54)";
    public static final String MESSAGE = "[{\"role\":\"user\",\"content\":\"%s\"}]";
    public final Set<String> cooldown = new HashSet<String>();
    @Inject(value="tip")
    private LanguageItem tip;
    @Inject
    private Logger logger;
    @Inject
    private LanguageEntry language;

    public static void chatgpt(String model, String content, Consumer<String> out, Consumer<String> badLine) {
        String delta;
        String line;
        String s = HttpRequest.https((HttpMethod)HttpMethod.GET, (String)model).browserBehavior(false).param("type", "stream").param("messages", MESSAGE.formatted(content.replace(" ", "$$") + PROMPT)).build().request();
        StringBuilder sb = new StringBuilder();
        String[] stringArray = s.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n && !(line = (delta = stringArray[i]).replace("data:", "").trim()).equals("[DONE]"); ++i) {
            try {
                JsonObject root;
                JsonArray choices;
                JsonObject choice;
                JsonObject delta2;
                JsonElement doc = SharedObjects.JSON_PARSER.parse(line);
                if (doc instanceof JsonNull || !(delta2 = (choice = (choices = (root = doc.getAsJsonObject()).get("choices").getAsJsonArray()).get(0).getAsJsonObject()).get("delta").getAsJsonObject()).has("content")) continue;
                String s2 = delta2.get("content").getAsString();
                sb.append(s2);
                continue;
            }
            catch (Exception ignored) {
                badLine.accept(line);
            }
        }
        out.accept(sb.toString());
    }

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        super.enable();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        super.disable();
    }

    public void onCommand(CommandSender sender, String[] args) {
        if (this.cooldown.contains(sender.getName())) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"cooldown", (Object[])new Object[]{10});
            return;
        }
        this.cooldown.add(sender.getName());
        TaskService.global().delay(200L, () -> this.cooldown.remove(sender.getName()));
        TaskService.async().run(() -> {
            StringBuilder sb = new StringBuilder();
            String model = GPT35;
            for (String str : args) {
                if (Objects.equals(str, "-gpt4")) {
                    model = GPT40;
                    continue;
                }
                sb.append(str).append(" ");
            }
            String request = sb.toString().trim();
            if (model.equals(GPT40)) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"request-gpt4", (Object[])new Object[]{"{;}" + request});
            } else {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"request", (Object[])new Object[]{"{;}" + request});
            }
            ChatGPT.chatgpt(model, request, s -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"response", (Object[])new Object[]{s}), line -> this.logger.warn("pared bad response flow: " + line));
        });
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        tabList.add("-gpt4");
    }
}

