/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.assertion.NumberLimitation;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.CachedInfo;

@CommandProvider(value={MuteCommand.class, UnmuteCommand.class})
@AutoRegister(value={"qb:el"})
@QuarkModule(id="chat-mute", version="1.0.2")
public final class ChatMute
extends PackageModule
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onChatting(AsyncPlayerChatEvent event) {
        this.checkEvent(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void detectCommand(PlayerCommandPreprocessEvent event) {
        if (!event.getMessage().contains("say") && !event.getMessage().contains("tell")) {
            return;
        }
        this.checkEvent(event.getPlayer(), (Cancellable)event);
    }

    public void checkEvent(Player p, Cancellable event) {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        if (!tag.hasKey(p.getName())) {
            return;
        }
        long expire = tag.getLong(p.getName());
        String expired = SharedObjects.DATE_FORMAT.format(new Date(expire));
        if (expire != 0L && System.currentTimeMillis() > expire) {
            return;
        }
        if (expire == 0L) {
            expired = "9999-12-31 23:59:59";
        }
        event.setCancelled(true);
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)((CommandSender)Objects.requireNonNull(p.getPlayer())), (String)"message-banned", (Object[])new Object[]{expired});
    }

    @QuarkCommand(name="mute", op=true)
    public static final class MuteCommand
    extends ModuleCommand<ChatMute> {
        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, (Collection)CachedInfo.getAllPlayerNames());
            suggestion.suggest(1, new String[]{"time[seconds]", "forever"});
            suggestion.suggest(2, new String[]{"<reason>"});
        }

        public void execute(CommandExecution context) {
            int length = 0;
            String target = context.requireArgumentAt(0);
            String reason = context.requireRemainAsParagraph(2, true);
            if (!Objects.equals(context.requireArgumentAt(1), "forever")) {
                length = context.requireArgumentInteger(1, new NumberLimitation[]{NumberLimitation.moreThan((double)0.0)});
            }
            long expire = length != 0 ? System.currentTimeMillis() + (long)length * 1000L : 0L;
            String expired = SharedObjects.DATE_FORMAT.format(new Date(expire));
            if (expire == 0L) {
                expired = "9999-12-31 23:59:59";
            }
            ModuleDataService.getEntry((String)this.getModuleId()).hasKey(target);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"add", (Object[])new Object[]{target, expired, reason});
            Player player = Bukkit.getPlayerExact((String)target);
            NBTTagCompound tag = ModuleDataService.getEntry((String)this.getModuleId());
            if (!tag.hasKey(target)) {
                tag.setLong(target, expire);
            }
            ModuleDataService.save((String)this.getModuleId());
            if (player != null && !target.equals(context.getSender().getName())) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"add-target", (Object[])new Object[]{context.getSender().getName(), reason, expired});
            }
        }
    }

    @QuarkCommand(name="unmute", permission="-quark.unmute")
    public static final class UnmuteCommand
    extends ModuleCommand<ChatMute> {
        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, ModuleDataService.getEntry((String)this.getModuleId()).getTagMap().keySet());
        }

        public void execute(CommandExecution context) {
            CommandSender sender = context.getSender();
            String target = context.requireArgumentAt(0);
            NBTTagCompound tag = ModuleDataService.getEntry((String)this.getModuleId());
            if (tag.hasKey(target)) {
                tag.remove(target);
            }
            ModuleDataService.save((String)this.getModuleId());
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"remove", (Object[])new Object[]{target});
            Player player = Bukkit.getPlayerExact((String)target);
            if (player != null && !target.equals(context.getSender().getName())) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)player, (String)"remove-target", (Object[])new Object[]{sender.getName()});
            }
        }
    }
}

