/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.gb2022.commons.math.SHA;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.atcraftmc.quark.CustomChatRenderer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.data.record.RecordEntry;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.APIProfile;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.framework.event.CustomEvent;
import org.tbstcraft.quark.framework.event.QuarkEvent;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.0", compatBlackList={APIProfile.SPIGOT, APIProfile.BUKKIT, APIProfile.ARCLIGHT})
@CommandProvider(value={ChatReportCommand.class})
@AutoRegister(value={"qb:el"})
public final class ChatReport
extends PackageModule {
    private final Map<String, String> records = new HashMap<String, String>();
    @Inject(value="tip")
    private LanguageItem tip;
    @Inject(value="chat-report;Time,OperationID,Reporter,SendTime,Sender,Content")
    private RecordEntry record;

    public static String hash(String s) {
        return SHA.getSHA1((String)s, (boolean)false).substring(9);
    }

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        this.record.open();
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        this.record.close();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChat(AsyncChatEvent event) {
        String sender = event.getPlayer().getName();
        String time = SharedObjects.DATE_FORMAT.format(new Date());
        String content = LegacyComponentSerializer.legacySection().serialize(event.message());
        String shorted = (content.substring(0, Math.min(content.length(), 4)) + "...").replace(" ", "");
        String uuid = ChatReport.hash(content);
        String template = Objects.requireNonNull(this.getConfig().value("append").string()).formatted(uuid);
        CustomChatRenderer.renderer(event).postfixNearest((ComponentLike)TextBuilder.buildComponent((String)template, (Component[])new Component[0]));
        this.records.put(uuid, "%s;%s;%s;%s".formatted(time, sender, content, shorted));
    }

    @QuarkCommand(name="chat-report")
    public static final class ChatReportCommand
    extends ModuleCommand<ChatReport> {
        public void onCommand(CommandSender sender, String[] args) {
            ChatReport handle = (ChatReport)this.getModule();
            if (!handle.records.containsKey(args[0])) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"not-exist", (Object[])new Object[0]);
                return;
            }
            String[] rec = handle.records.get(args[0]).split(";");
            if (rec[1].equalsIgnoreCase(sender.getName())) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"not-self", (Object[])new Object[0]);
                return;
            }
            handle.records.remove(args[0]);
            handle.getLanguage().item("success").send((Object)sender, new Object[]{rec[1], rec[3]});
            handle.record.addLine(new Object[]{SharedObjects.DATE_FORMAT.format(new Date()), args[0], sender.getName(), rec[0], rec[1], rec[2]});
            BukkitUtil.callEvent((Event)new ChatReportedEvent(rec[1], rec[2], rec[3], args[0]), (Consumer[])new Consumer[]{e -> {
                if (e.getOutcome() == null) {
                    return;
                }
                e.getOutcome().send((Object)sender, new Object[]{rec[1], rec[3]});
            }});
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.add("<uuid>");
            }
        }
    }

    @QuarkEvent
    public static final class ChatReportedEvent
    extends CustomEvent {
        private final String sender;
        private final String content;
        private final String shorted;
        private final String uuid;
        private LanguageItem outcome;

        public ChatReportedEvent(String sender, String content, String shorted, String uuid) {
            this.sender = sender;
            this.content = content;
            this.shorted = shorted;
            this.uuid = uuid;
        }

        public static HandlerList getHandlerList() {
            return ChatReportedEvent.getHandlerList(ChatReportedEvent.class);
        }

        public String getContent() {
            return this.content;
        }

        public String getSender() {
            return this.sender;
        }

        public String getShorted() {
            return this.shorted;
        }

        public String getUuid() {
            return this.uuid;
        }

        public LanguageItem getOutcome() {
            return this.outcome;
        }

        public void setOutcome(LanguageItem outcome) {
            this.outcome = outcome;
        }
    }
}

