/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.quark.chat.ChatForwardingService;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.tbstcraft.quark.PlayerView;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.data.storage.StorageTable;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.util.PlayerMap;

@QuarkModule
@AutoRegister(value={"qb:el"})
@QuarkCommand(name="display-setting", permission="quark.display.setting")
public class DisplaySetting
extends CommandModule {
    private final PlayerMap<Boolean> chatRejections = new PlayerMap();

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"hud", "chat"});
    }

    public void execute(CommandExecution context) {
        this.toggle(context.requireSenderAsPlayer(), context.requireArgumentAt(1));
    }

    @EventHandler
    public void onForwardingChat(ChatForwardingService.ChatForwardingEvent event) {
        Player audience = event.getViewer();
        if (((Boolean)this.chatRejections.computeIfAbsent(audience, p -> true)).booleanValue()) {
            return;
        }
        event.setCancelled(true);
    }

    private void toggle(Player player, String mode) {
        boolean open;
        String key;
        PlayerView view = PlayerView.getInstance((Player)player);
        StorageTable data = PlayerDataService.get((Player)player).getTable("display-setting");
        if (!data.hasKey(key = mode.toLowerCase())) {
            open = true;
            data.setBoolean(key, true);
        } else {
            open = data.getBoolean(key);
            data.setBoolean(key, !open);
        }
        data.save();
        switch (mode) {
            case "chat": {
                this.chatRejections.put(player, (Object)open);
                break;
            }
            case "hud": {
                view.getActionbar().rejectAll(!open);
            }
        }
    }
}

