/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import java.util.HashSet;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.data.storage.DataEntry;
import org.tbstcraft.quark.data.storage.StorageTable;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.BukkitSound;

@QuarkCommand(name="mail", playerOnly=true)
@QuarkModule(id="mail", version="1.0.0")
@AutoRegister(value={"qb:el"})
public final class Mail
extends CommandModule {
    @Inject
    private LanguageEntry language;

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.tryRemindPlayer(event.getPlayer());
    }

    private void tryRemindPlayer(Player player) {
        TaskService.async().run(() -> {
            StorageTable entry = this.data((OfflinePlayer)player);
            int size = entry.getTagMap().keySet().size();
            if (size == 0) {
                return;
            }
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)player, (String)"view-hint", (Object[])new Object[]{size});
        });
    }

    private void view(CommandSender sender, StorageTable data) {
        StringBuilder sb = new StringBuilder();
        HashSet keys = new HashSet(data.getTagMap().keySet());
        if (keys.isEmpty()) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"view-none", (Object[])new Object[]{sb.toString()});
            return;
        }
        for (String s : keys) {
            String template = this.getConfig().value("template").string();
            if (template == null) {
                template = "%s@%s: %s";
            }
            try {
                String from = s.split("@")[0];
                String time = SharedObjects.DATE_FORMAT.format(Long.parseLong(s.split("@")[1]));
                sb.append(template.formatted(time, from, data.getString(s))).append("\n");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            data.remove(s);
        }
        data.save();
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"view", (Object[])new Object[]{sb.toString()});
    }

    private void send(OfflinePlayer recipient, CommandSender sender, String content) {
        if (recipient.isOnline()) {
            if (this.getConfig().value("sound").bool()) {
                BukkitSound.ANNOUNCE.play(recipient.getPlayer());
            }
            if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"send-direct-to-online-player")) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)recipient.getPlayer(), (String)"receive-direct", (Object[])new Object[]{sender.getName(), content});
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"send-success", (Object[])new Object[]{recipient, content});
                return;
            }
        }
        StorageTable entry = this.data(recipient);
        String key = sender.getName() + "@" + System.currentTimeMillis();
        entry.setString(key, content);
        entry.save();
        MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"send-success", (Object[])new Object[]{recipient.getName(), content});
        if (recipient.isOnline()) {
            this.tryRemindPlayer(recipient.getPlayer());
        }
    }

    public void execute(CommandExecution context) {
        CommandSender sender = context.getSender();
        if (context.requireArgumentAt(0).equals("view")) {
            StorageTable entry = this.data((OfflinePlayer)context.requireSenderAsPlayer());
            TaskService.async().run(() -> this.view(context.getSender(), entry));
        }
        String content = "{;}" + context.requireRemainAsParagraph(1, true) + "{;}";
        OfflinePlayer recipient = context.requireOfflinePlayer(0);
        this.send(recipient, sender, content);
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggestPlayers(0);
        suggestion.suggest(0, new String[]{"view"});
        suggestion.suggest(1, new String[]{"[message...]"});
    }

    private StorageTable data(OfflinePlayer player) {
        DataEntry data = PlayerDataService.get((String)player.getName());
        if (!data.hasKey(this.getFullId())) {
            data.setCompoundTag(this.getFullId(), new NBTTagCompound());
        }
        return data.getTable(this.getFullId());
    }
}

