/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.texts.ComponentBlock;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.BukkitSound;

@QuarkCommand(name="npc-chat")
@QuarkModule(version="1.0.0")
public final class NPCChat
extends CommandModule {
    private final Map<String, ConfigurationSection> contexts = new HashMap<String, ConfigurationSection>();
    private final Map<String, Integer> audienceIndexes = new HashMap<String, Integer>();
    private final Map<String, Long> audienceChatRecord = new HashMap<String, Long>();
    @Inject(value="npc-conversation;false")
    private AssetGroup conversations;
    @Inject
    private Logger logger;

    public void enable() {
        super.enable();
        if (!this.conversations.existFolder()) {
            this.conversations.save("gb.yml");
            this.conversations.save("tbs.yml");
        }
        for (String k : this.conversations.list()) {
            String name = k.replace(".yml", "");
            YamlConfiguration dom = YamlConfiguration.loadConfiguration((File)this.conversations.getFile(k));
            this.contexts.put(name, dom.getConfigurationSection("conversation"));
            this.logger.info("loaded conversation %s".formatted(k));
        }
    }

    private int getConversationIndex(String sender, int limit) {
        long current = System.currentTimeMillis();
        if (!this.audienceChatRecord.containsKey(sender)) {
            this.audienceChatRecord.put(sender, System.currentTimeMillis());
            this.audienceIndexes.put(sender, 0);
            return 0;
        }
        if (current - this.audienceChatRecord.get(sender) > (long)ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"inactive-time")) {
            this.audienceChatRecord.put(sender, System.currentTimeMillis());
            this.audienceIndexes.put(sender, 0);
            return 0;
        }
        int index = this.audienceIndexes.get(sender) + 1;
        if (index >= limit) {
            index = 0;
        }
        this.audienceChatRecord.put(sender, System.currentTimeMillis());
        this.audienceIndexes.put(sender, index);
        return index;
    }

    public void onCommand(CommandSender sender, String[] args) {
        ConfigurationSection conversation = this.contexts.get(args[0]);
        if (conversation == null) {
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"not-found", (Object[])new Object[0]);
            return;
        }
        String template = Objects.requireNonNull(this.getConfig().value("template").string());
        String locale = LocaleService.locale((CommandSender)sender).minecraft();
        String name = Objects.requireNonNull(conversation.getString("name." + locale));
        List texts = conversation.getStringList(locale);
        String text = (String)texts.get(this.getConversationIndex(sender.getName() + ":" + args[0], texts.size()));
        TextSender.sendBlock((CommandSender)sender, (ComponentBlock)TextBuilder.build((String)template.replace("{name}", name).replace("{text}", text), (Component[])new Component[0]));
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"sound") && sender instanceof Player) {
            BukkitSound.ANNOUNCE.play((Player)sender);
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.addAll(this.contexts.keySet());
        }
    }
}

