/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.chat;

import java.net.ConnectException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.gb2022.commons.http.HttpMethod;
import me.gb2022.commons.http.HttpRequest;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.tbstcraft.quark.foundation.ComponentSerializer;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;

@QuarkModule(beta=true)
@AutoRegister(value={"qb:el"})
public final class QQChatSync
extends PackageModule {
    @Inject
    private Logger logger;

    public static void send(String address, String token, String group, String message, Logger handle) {
        String parsed = StringEscapeUtils.escapeHtml4((String)URLEncoder.encode(message, StandardCharsets.UTF_8));
        try {
            HttpRequest.http((HttpMethod)HttpMethod.POST, (String)address).path("/send_group_msg").browserBehavior(true).param("access_token", token).param("group_id", group).param("message", parsed).header("Content-Type", null).header("Encoding", "UTF-8").build().request();
        }
        catch (RuntimeException e) {
            try {
                throw e.getCause();
            }
            catch (ConnectException ex) {
                handle.error("failed to connect to LLOneBot server: " + address, (Throwable)ex);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        TaskService.async().run(() -> {
            String fmt = this.getConfig().value("message").string();
            String msg = fmt.formatted(event.getPlayer().getName(), event.getMessage());
            String token = this.getConfig().value("token").string();
            String address = this.getConfig().value("address").string();
            String message = ComponentSerializer.plain((Component)TextBuilder.buildComponent((String)PlaceHolderService.formatPlayer((Player)event.getPlayer(), (String)msg), (Component[])new Component[0]));
            for (String target : ConfigAccessor.configList((ConfigEntry)this.getConfig(), (String)"targets", String.class)) {
                QQChatSync.send(address, token, target, message, this.logger);
            }
        });
    }
}

