/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.commands;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.AbstractCommand;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.tbstcraft.quark.data.assets.AssetGroup;
import org.tbstcraft.quark.foundation.command.QuarkCommandManager;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
public final class CommandFunction
extends PackageModule {
    private final Set<AdapterCommand> commands = new HashSet<AdapterCommand>();
    @Inject(value="function;false")
    private AssetGroup functionFiles;
    @Inject
    private Logger logger;

    public void enable() {
        if (!this.functionFiles.existFolder()) {
            this.functionFiles.save("worldedit.yml");
        }
        for (String cfg : this.functionFiles.list()) {
            ConfigurationSection dom = YamlConfiguration.loadConfiguration((File)this.functionFiles.getFile(cfg)).getConfigurationSection("functions");
            assert (dom != null);
            for (String tagName : dom.getKeys(false)) {
                AdapterCommand adapter = new AdapterCommand(tagName, dom.getStringList(tagName));
                this.commands.add(adapter);
                QuarkCommandManager.getInstance().register((AbstractCommand)adapter);
            }
            this.logger.info("loaded function provider file %s.".formatted(cfg));
        }
    }

    public void disable() {
        for (AdapterCommand command : this.commands) {
            QuarkCommandManager.getInstance().unregister((AbstractCommand)command);
        }
    }

    @QuarkCommand(name="__dummy")
    public static class AdapterCommand
    extends AbstractCommand {
        private final String trigger;
        private final List<String> triggerList;

        public AdapterCommand(String trigger, List<String> triggerList) {
            this.trigger = trigger;
            this.triggerList = triggerList;
        }

        @NotNull
        public String getName() {
            return this.trigger;
        }

        public boolean isOP() {
            return false;
        }

        public void onCommand(CommandSender sender, String[] args) {
            for (String pattern : this.triggerList) {
                for (int i = 0; i < args.length; ++i) {
                    pattern = pattern.replace("{arg%d}".formatted(i), args[i]);
                }
                ((Player)sender).performCommand(pattern);
            }
        }
    }
}

