/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.LegacyCommandManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.util.FilePath;

@QuarkModule(version="1.2.0")
@AutoRegister(value={"qb:el"})
@Components(value={WEAddition.class})
public final class CommandTabFix
extends PackageModule {
    public static boolean isCommandNameMatch(TabCompleteEvent event, String ... names) {
        for (String name : names) {
            if (!event.getBuffer().startsWith(name) && !event.getBuffer().startsWith("/" + name)) continue;
            return true;
        }
        return false;
    }

    public static String[] getArguments(TabCompleteEvent event) {
        String[] args = event.getBuffer().split(" ");
        if (args.length <= 1) {
            return new String[0];
        }
        return args;
    }

    public static String getLastArgument(TabCompleteEvent event) {
        String[] args = CommandTabFix.getArguments(event);
        return args[args.length - 1];
    }

    public static void handleCompletion(TabCompleteEvent event, Consumer<List<String>> action) {
        ArrayList list = new ArrayList(event.getCompletions());
        action.accept(list);
        event.setCompletions(list);
    }

    public void enable() {
        TaskService.global().delay(1000L, LegacyCommandManager::sync);
    }

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("org.bukkit.event.server.TabCompleteEvent"));
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent event) {
        ArrayList<String> match = new ArrayList<String>();
        String[] args = event.getBuffer().split(" ");
        if (args.length <= 1) {
            return;
        }
        String lastArg = args[args.length - 1];
        if (event.getBuffer().charAt(event.getBuffer().length() - 1) != ' ') {
            for (String s : event.getCompletions()) {
                if (!s.contains(lastArg)) continue;
                match.add(s);
            }
            event.setCompletions(match);
        }
        if (CommandTabFix.isCommandNameMatch(event, "reload") && !event.getCompletions().contains("confirm")) {
            ArrayList<String> list = new ArrayList<String>(event.getCompletions());
            list.add("confirm");
            event.setCompletions(list);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        LegacyCommandManager.sync();
    }

    @AutoRegister(value={"qb:el"})
    public static final class MVAddition
    extends ModuleComponent<CommandTabFix> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requirePlugin((String)"Multiverse-Core");
        }

        @EventHandler
        public void onTabComplete(TabCompleteEvent event) {
        }
    }

    @AutoRegister(value={"qb:el"})
    public static final class WEAddition
    extends ModuleComponent<CommandTabFix> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requirePlugin((String)"WorldEdit");
        }

        @EventHandler
        public void onTabComplete(TabCompleteEvent event) {
            if (CommandTabFix.isCommandNameMatch(event, "/schem", "/schematic")) {
                if (!CommandTabFix.getLastArgument(event).equals("load") && !CommandTabFix.getLastArgument(event).equals("delete")) {
                    return;
                }
                File folder = new File(FilePath.pluginsFolder() + "/WorldEdit/schematics");
                CommandTabFix.handleCompletion(event, list -> {
                    for (File f : Objects.requireNonNull(folder.listFiles())) {
                        list.add(f.getName());
                    }
                });
            }
            if (CommandTabFix.isCommandNameMatch(event, "set") && CommandTabFix.getArguments(event).length <= 2) {
                CommandTabFix.handleCompletion(event, list -> list.add("hand"));
            }
            if (CommandTabFix.isCommandNameMatch(event, "replace") && CommandTabFix.getArguments(event).length <= 3) {
                CommandTabFix.handleCompletion(event, list -> list.add("hand"));
            }
        }
    }
}

