/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.data.storage.DataEntry;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@CommandProvider(value={VariableCommand.class})
@AutoRegister(value={"qb:el"})
public class CommandVariables
extends PackageModule
implements QuarkCommandExecutor {
    public static final Pattern EXTRACT_VARIABLES = Pattern.compile("\\$\\[.*?]");
    private final Map<String, DataStorage> storages = new HashMap<String, DataStorage>();

    public void enable() {
        this.storages.put("plugin", new DataStorage.PluginLifetime());
        this.storages.put("persistent", new DataStorage.Persistent());
    }

    @EventHandler
    public void onServerCommand(ServerCommandEvent e) {
        if (e.getCommand().startsWith("/variable") || e.getCommand().startsWith("variable")) {
            return;
        }
        e.setCommand(this.variables(e.getCommand()));
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (e.getMessage().startsWith("/variable") || e.getMessage().startsWith("variable")) {
            return;
        }
        e.setMessage(this.variables(e.getMessage()));
    }

    public String variables(String command) {
        Matcher matcher = EXTRACT_VARIABLES.matcher(command);
        while (matcher.find()) {
            String expr = matcher.group();
            String key = expr.substring(2, expr.length() - 1);
            String value = "null";
            for (DataStorage storage : this.storages.values()) {
                String v = storage.get(key);
                if (v == null) continue;
                value = v;
                break;
            }
            command = command.replace(expr, value);
        }
        if (EXTRACT_VARIABLES.matcher(command).find()) {
            try {
                return this.variables(command);
            }
            catch (StackOverflowError e) {
                return command;
            }
        }
        return command;
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"set", "get", "delete"});
        suggestion.suggest(1, this.storages.keySet());
        suggestion.suggest(3, new String[]{"[value....]"});
        if (suggestion.getBuffer().size() - 1 >= 2) {
            DataStorage storage = this.storages.get(suggestion.getBuffer().get(1));
            if (storage == null) {
                return;
            }
            suggestion.suggest(2, storage.list());
        }
    }

    public void execute(CommandExecution context) {
        CommandSender sender = context.getSender();
        String sid = context.requireEnum(1, this.storages.keySet());
        String name = context.requireArgumentAt(2);
        DataStorage data = this.storages.get(sid);
        switch (context.requireEnum(0, new String[]{"set", "delete", "get"})) {
            case "set": {
                String value = context.requireRemainAsParagraph(3, true);
                data.set(name, value);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"set", (Object[])new Object[]{sid, name, value});
                break;
            }
            case "get": {
                String v = Objects.requireNonNullElse(data.get(name), "[null]");
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"get", (Object[])new Object[]{sid, name, v});
                break;
            }
            case "delete": {
                data.clear(name);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"delete", (Object[])new Object[]{sid, name});
            }
        }
    }

    static interface DataStorage {
        public String get(String var1);

        public void set(String var1, String var2);

        default public void clear(String name) {
            this.set(name, null);
        }

        public Collection<String> list();

        public static class Persistent
        implements DataStorage {
            @Override
            public String get(String name) {
                DataEntry data = ModuleDataService.get((String)"variables");
                if (!data.hasKey(name)) {
                    return null;
                }
                return data.getString(name);
            }

            @Override
            public void set(String name, String value) {
                DataEntry data = ModuleDataService.get((String)"variables");
                data.setString(name, value);
                data.save();
            }

            @Override
            public Collection<String> list() {
                DataEntry data = ModuleDataService.get((String)"variables");
                return data.getTagMap().keySet();
            }

            @Override
            public void clear(String name) {
                DataEntry data = ModuleDataService.get((String)"variables");
                data.remove(name);
                data.save();
            }
        }

        public static class PluginLifetime
        extends HashMap<String, String>
        implements DataStorage {
            @Override
            public String get(String name) {
                return (String)this.get((Object)name);
            }

            @Override
            public void set(String name, String value) {
                this.put(name, value);
            }

            @Override
            public Collection<String> list() {
                return this.keySet();
            }

            @Override
            public void clear(String name) {
                this.remove(name);
            }
        }
    }

    @QuarkCommand(name="variable", permission="-quark.commands.variable")
    public static class VariableCommand
    extends ModuleCommand<CommandVariables> {
        public void init(CommandVariables module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

