/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.gb2022.commons.Formating;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.1")
@AutoRegister(value={"qb:el"})
public final class AFK
extends PackageModule {
    private final Listener actionListener = new PlayerActionListener();
    private final Map<String, Long> lastAFK = new HashMap<String, Long>();
    @Inject
    private LanguageEntry language;

    public void enable() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.restartAFKTimer(p);
        }
        BukkitUtil.registerEventListener((Listener)this.actionListener);
    }

    public void disable() {
        this.lastAFK.clear();
        BukkitUtil.unregisterEventListener((Listener)this.actionListener);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.lastAFK.put(e.getPlayer().getName(), -1L);
        String id = e.getPlayer().getName();
        String tid = "quark:afk:delay@" + id;
        TaskService.async().cancel(tid);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.lastAFK.put(e.getPlayer().getName(), -1L);
        this.restartAFKTimer(e.getPlayer());
    }

    private void broadcast(Player player, Consumer<Player> self, BiConsumer<Player, Player> others) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getName().equals(player.getName())) {
                self.accept(player);
                continue;
            }
            others.accept(p, player);
        }
    }

    private void restartAFKTimer(Player player) {
        String id = player.getName();
        String tid = "quark:afk:delay@" + id;
        TaskService.async().cancel(tid);
        long timestamp = System.currentTimeMillis();
        TaskService.async().delay(tid, (long)ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"timeout"), () -> {
            if (!player.isOnline()) {
                return;
            }
            this.broadcast(player, p -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"left-self", (Object[])new Object[0]), (p, p2) -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"left", (Object[])new Object[]{p2.getName()}));
            this.lastAFK.put(id, timestamp);
        });
        if (!this.lastAFK.containsKey(player.getName())) {
            return;
        }
        if (this.lastAFK.get(player.getName()) == -1L) {
            return;
        }
        long current = System.currentTimeMillis();
        long during = current - this.lastAFK.get(id);
        this.lastAFK.put(player.getName(), -1L);
        String time = Formating.formatDuringFull((long)during);
        this.broadcast(player, p -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"back-self", (Object[])new Object[]{time}), (p, p2) -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"back", (Object[])new Object[]{p2.getName(), time}));
    }

    public class PlayerActionListener
    implements Listener {
        @EventHandler
        public void onPlayerChat(AsyncPlayerChatEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onBlockBreak(BlockBreakEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onBlockPlace(BlockPlaceEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onPlayerMove(PlayerMoveEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onPlayerInteract(PlayerInteractEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }

        @EventHandler
        public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent e) {
            AFK.this.restartAFKTimer(e.getPlayer());
        }
    }
}

