/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.md_5.bungee.api.chat.BaseComponent;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.PlayerView;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.APIProfile;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@AutoRegister(value={"qb:el"})
public final class ActionBarHUD
extends PackageModule {
    @Inject
    private LanguageEntry language;

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireMethod(() -> Player.class.getDeclaredMethod("sendActionBar", BaseComponent[].class));
        Compatibility.blackListPlatform((APIProfile[])new APIProfile[]{APIProfile.ARCLIGHT, APIProfile.BANNER, APIProfile.YOUER});
    }

    private String render(Player player) {
        Location loc = player.getLocation();
        Block block = loc.getBlock();
        MinecraftLocale locale = LocaleService.locale((CommandSender)player);
        String biome_n = block.getBiome().getKey().getNamespace();
        String biome_k = block.getBiome().getKey().getKey();
        String p = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"position", (Object[])new Object[]{loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()});
        String b = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"biome", (Object[])new Object[]{biome_n, biome_k});
        String t = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"time", (Object[])new Object[0]);
        String f = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"face", (Object[])new Object[]{SharedObjects.NUMBER_FORMAT.format(loc.getYaw()), SharedObjects.NUMBER_FORMAT.format(loc.getPitch())});
        String template = this.getConfig().value("template").string().replace("{position}", p).replace("{biome}", b).replace("{time}", t).replace("{face}", f);
        return PlaceHolderService.formatPlayer((Player)player, (String)template);
    }

    private void startRender(Player player) {
        PlayerView.getInstance((Player)player).getActionbar().addChannel("quark:actionbar-hud", -10, 3, TaskService::entity, (p, c) -> {
            Component comp = TextBuilder.buildComponent((String)this.render(p), (Component[])new Component[0]);
            TextSender.sendActionbarTitle((Player)p, (ComponentLike)comp);
        });
    }

    private void stopRender(Player player) {
        PlayerView.getInstance((Player)player).getActionbar().removeChannel("quark:actionbar-hud");
    }

    public void enable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.startRender(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.startRender(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.stopRender(event.getPlayer());
    }
}

