/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.api.ClientLocaleChangeEvent;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.APIProfileTest;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@CommandProvider(value={BossbarAnnounceCommand.class})
@QuarkModule(version="1.1.0")
public final class BossbarAnnouncement
extends PackageModule {
    public static final String TASK_UPDATE_TID = "quark-display:custom_bossbar:update";
    private final HashMap<MinecraftLocale, BossbarWrapper> bars = new HashMap();
    private String content = null;
    @Inject
    private LanguageEntry language;

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("org.bukkit.boss.BossBar"));
        Compatibility.requireClass(() -> Class.forName("org.bukkit.boss.BarColor"));
        Compatibility.requireClass(() -> Class.forName("org.bukkit.boss.BarStyle"));
    }

    public void enable() {
        ConfigEntry config = this.getConfig();
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getId());
        if (tag.hasKey("custom")) {
            this.content = tag.getString("custom");
        }
        TaskService.async().timer(TASK_UPDATE_TID, 0L, (long)ConfigAccessor.getInt((ConfigEntry)config, (String)"period"), this::updateBossbar);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.addBar(player);
        }
    }

    public void disable() {
        TaskService.async().cancel(TASK_UPDATE_TID);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeBar(player);
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.addBar(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeBar(event.getPlayer());
    }

    @EventHandler
    public void onPlayerLocaleChange(ClientLocaleChangeEvent event) {
        this.removeBar(event.getPlayer());
        this.addBar(event.getPlayer());
    }

    public void addBar(Player p) {
        MinecraftLocale locale = LocaleService.locale((CommandSender)p);
        BossbarWrapper b = this.bars.computeIfAbsent(locale, s -> this.generateBossbar(locale));
        b.add(p);
    }

    public void removeBar(Player p) {
        MinecraftLocale locale = LocaleService.locale((CommandSender)p);
        for (BossbarWrapper bar : new ArrayList<BossbarWrapper>(this.bars.values())) {
            bar.remove(p);
        }
        BossbarWrapper bar = this.bars.get(LocaleService.locale((CommandSender)p));
        if (bar == null) {
            return;
        }
        if (bar.getAudiences().isEmpty()) {
            this.bars.remove(locale);
        }
    }

    private BossbarWrapper generateBossbar(MinecraftLocale locale) {
        String msg = this.getLanguage().inline(Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[0]), locale);
        BossbarWrapper wrapper = BossbarWrapper.create();
        wrapper.color(this.getConfig().value("bar-color").string());
        wrapper.title(TextBuilder.buildComponent((String)msg, (Component[])new Component[0]));
        return wrapper;
    }

    public void updateBossbar() {
        for (MinecraftLocale locale : this.bars.keySet()) {
            String msg = this.getLanguage().inline(Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[0]), locale);
            BossbarWrapper bar = this.bars.get(locale);
            if (this.content != null) {
                bar.title(TextBuilder.buildComponent((String)this.content, (Component[])new Component[0]));
                continue;
            }
            bar.title(TextBuilder.buildComponent((String)msg, (Component[])new Component[0]));
        }
    }

    static interface BossbarWrapper {
        public static BossbarWrapper create() {
            if (APIProfileTest.isPaperCompat()) {
                return new AdventureBossbar();
            }
            return new BukkitBossbar();
        }

        public void add(Player var1);

        public void remove(Player var1);

        public void title(Component var1);

        public void color(String var1);

        public Set<Player> getAudiences();

        public static final class AdventureBossbar
        implements BossbarWrapper {
            private final BossBar bar;
            private final Set<Player> players = new HashSet<Player>();

            public AdventureBossbar() {
                this.bar = BossBar.bossBar((ComponentLike)Component.text(), (float)1.0f, (BossBar.Color)BossBar.Color.WHITE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
            }

            @Override
            public void add(Player audience) {
                audience.showBossBar(this.bar);
                this.players.add(audience);
            }

            @Override
            public void remove(Player audience) {
                audience.hideBossBar(this.bar);
                this.players.remove(audience);
            }

            @Override
            public void title(Component title) {
                this.bar.name(title);
            }

            @Override
            public void color(String content) {
                this.bar.color(BossBar.Color.valueOf((String)content.toUpperCase()));
            }

            @Override
            public Set<Player> getAudiences() {
                return this.players;
            }
        }

        public static final class BukkitBossbar
        implements BossbarWrapper {
            private final org.bukkit.boss.BossBar bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);

            @Override
            public void add(Player audience) {
                this.bar.addPlayer(audience);
            }

            @Override
            public void remove(Player audience) {
                this.bar.removePlayer(audience);
            }

            @Override
            public void title(Component title) {
                this.bar.setTitle(LegacyComponentSerializer.legacySection().serialize(title));
            }

            @Override
            public void color(String content) {
                this.bar.setColor(BarColor.valueOf((String)content.toUpperCase()));
            }

            @Override
            public Set<Player> getAudiences() {
                return new HashSet<Player>(this.bar.getPlayers());
            }
        }
    }

    @QuarkCommand(name="bossbar-announce", op=true)
    public static final class BossbarAnnounceCommand
    extends ModuleCommand<BossbarAnnouncement> {
        public void onCommand(CommandSender sender, String[] args) {
            NBTTagCompound tag = ModuleDataService.getEntry((String)this.getModuleId());
            if (Objects.equals(args[0], "none")) {
                tag.remove("custom");
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"custom-clear", (Object[])new Object[0]);
                ((BossbarAnnouncement)this.getModule()).setContent(null);
            } else {
                StringBuilder sb = new StringBuilder();
                for (String s : args) {
                    sb.append(s).append(" ");
                }
                String content = PlaceHolderService.format((String)sb.toString());
                tag.setString("custom", content);
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"custom-set", (Object[])new Object[]{content});
                ((BossbarAnnouncement)this.getModule()).setContent(content);
            }
            ((BossbarAnnouncement)this.getModule()).updateBossbar();
            ModuleDataService.save((String)this.getModuleId());
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.add("[content]");
                tabList.add("none");
            }
        }
    }
}

