/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="0.3.0")
@AutoRegister(value={"qb:el"})
@CommandProvider(value={HintCommand.class})
public final class ChatAnnounce
extends PackageModule {
    private Set<Player> sessions = new HashSet<Player>();
    private long index;
    private boolean freeze;
    @Inject
    private LanguageEntry language;

    public void enable() {
        this.sessions.addAll(Bukkit.getOnlinePlayers());
        this.tick();
        int p = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"period");
        TaskService.async().timer("chat-announce:tick", (long)p, (long)p, this::tick);
    }

    public void disable() {
        this.sessions = null;
        TaskService.async().cancel("chat-announce:tick");
    }

    @EventHandler
    private void onChat(AsyncPlayerChatEvent event) {
        this.freeze = false;
    }

    public void tick() {
        if (this.sessions == null) {
            return;
        }
        if (this.freeze) {
            return;
        }
        ++this.index;
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.sendHint((CommandSender)p);
        }
        this.freeze = true;
    }

    private List<String> getContents(CommandSender sender) {
        return this.language.item("content").list(LocaleService.locale((CommandSender)sender));
    }

    private void sendHint(CommandSender sender) {
        MinecraftLocale locale = LocaleService.locale((CommandSender)sender);
        String msg = this.getContents(sender).get((int)(this.index % (long)this.getContents(sender).size()));
        String mode = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"type-hint", (Object[])new Object[0]);
        MessageAccessor.sendTemplate((LanguageEntry)this.language, (CommandSender)sender, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[]{s -> s.formatted(mode, msg)}));
    }

    private void sendAnnounce(CommandSender sender) {
        NBTTagCompound tag = ModuleDataService.getEntry((String)this.getFullId());
        if (!tag.hasKey("announce")) {
            return;
        }
        MinecraftLocale locale = LocaleService.locale((CommandSender)sender);
        String msg = tag.getString("announce");
        String mode = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"type-announce", (Object[])new Object[0]);
        MessageAccessor.sendTemplate((LanguageEntry)this.language, (CommandSender)sender, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[]{s -> s.formatted(mode, msg)}));
    }

    private void sendTip(CommandSender sender) {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> {
            ArrayList<LanguageItem> list = new ArrayList<LanguageItem>();
            for (Object o : s) {
                list.add((LanguageItem)o);
            }
            MinecraftLocale locale = LocaleService.locale((CommandSender)sender);
            String msg = ((LanguageItem)list.get(new Random().nextInt(list.size()))).message(locale, new Object[0]);
            String mode = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"type-tip", (Object[])new Object[0]);
            String btn = MessageAccessor.getMessage((LanguageEntry)this.language, (MinecraftLocale)locale, (String)"tip-append", (Object[])new Object[0]);
            MessageAccessor.sendTemplate((LanguageEntry)this.language, (CommandSender)sender, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[]{ss -> ss.formatted(mode + "  " + btn, msg)}));
        });
    }

    private void sendCustomActivity(CommandSender sender) {
        PluginStorage.set((String)"chat_announce/custom-activity", s -> {
            ArrayList<LanguageItem> list = new ArrayList<LanguageItem>();
            System.out.println(s);
            for (Object o : s) {
                list.add((LanguageItem)o);
            }
            if (list.isEmpty()) {
                return;
            }
            MinecraftLocale locale = LocaleService.locale((CommandSender)sender);
            String msg = ((LanguageItem)list.get(new Random().nextInt(list.size()))).message(locale, new Object[0]);
            MessageAccessor.sendTemplate((LanguageEntry)this.language, (CommandSender)sender, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[]{ss -> ss.formatted(msg.split("::"))}));
        });
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.sessions == null) {
            return;
        }
        this.sessions.add(event.getPlayer());
        this.sendTip((CommandSender)event.getPlayer());
        this.sendAnnounce((CommandSender)event.getPlayer());
        this.sendCustomActivity((CommandSender)event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.sessions == null) {
            return;
        }
        this.sessions.remove(event.getPlayer());
    }

    @QuarkCommand(name="chat-hint")
    public static final class HintCommand
    extends ModuleCommand<ChatAnnounce> {
        public void execute(CommandExecution context) {
            switch (context.requireEnum(0, new String[]{"hint", "tips"})) {
                case "hint": {
                    ((ChatAnnounce)this.getModule()).sendHint(context.getSender());
                    ++((ChatAnnounce)this.getModule()).index;
                    break;
                }
                case "tips": {
                    ((ChatAnnounce)this.getModule()).sendTip(context.getSender());
                }
            }
        }

        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, new String[]{"hint", "tip"});
        }

        public void onCommand(CommandSender sender, String[] args) {
            switch (args[0]) {
                case "announce": {
                    ((ChatAnnounce)this.getModule()).sendAnnounce(sender);
                    break;
                }
                case "set-announce": {
                    if (!sender.isOp()) {
                        this.sendPermissionMessage(sender, "(ServerOperator)");
                        return;
                    }
                    String content = Objects.equals(args[1], "none") ? null : args[1].replace(":blank:", " ") + "{;}";
                    String entry = this.getModuleFullId();
                    if (content == null) {
                        ModuleDataService.getEntry((String)entry).getTagMap().remove("announce");
                    } else {
                        ModuleDataService.getEntry((String)entry).setString("announce", content);
                    }
                    ModuleDataService.save((String)entry);
                    if (content == null) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"custom-clear", (Object[])new Object[0]);
                        break;
                    }
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (p == sender) continue;
                        ((ChatAnnounce)this.getModule()).sendAnnounce(sender);
                    }
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"custom-set", (Object[])new Object[]{content});
                    break;
                }
                case "view-activity": {
                    ((ChatAnnounce)this.getModule()).sendCustomActivity(sender);
                }
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.add("hint");
                tabList.add("tips");
                tabList.add("set-announce");
                tabList.add("announce");
                tabList.add("view-activity");
            }
        }
    }
}

