/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Date;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleRO0;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.atcraftmc.quark.CustomChatRenderer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.foundation.ComponentSerializer;
import org.tbstcraft.quark.foundation.TextExaminer;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.util.TemplateExpansion;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="1.2.0")
@Components(value={PaperChatListener.class})
public final class ChatFormat
extends PackageModule {
    MethodHandleRO0<World, String> getDimensionId = (MethodHandleRO0)MethodHandle.select(ctx -> {
        ctx.attempt(() -> World.class.getMethod("getKey", new Class[0]), w -> {
            String origin = w.getKey().toString();
            return origin.replace(":", "-").replace("_", "-").replace(".", "-");
        });
        ctx.dummy(w -> "minecraft-" + w.getName().replace("world", "overworld").replace("world-nether", "the-nether").replace("world-the-end", "the-end").replace("DIM0", "overworld").replace("DIM1", "the-end").replace("DIM-1", "the-nether"));
    });

    @EventHandler(priority=EventPriority.HIGH)
    public void onLegacyPlayerChat(AsyncPlayerChatEvent event) {
        String timeLine = this.getTime().replace("<post>", "");
        String expanded = TemplateExpansion.build(b -> {
            b.replacement("time");
            b.replacement("0");
            b.replacement("1");
        }).expand(this.getTemplate(event.getPlayer()), new Object[]{timeLine, event.getPlayer().getDisplayName(), "%2$s"});
        event.setFormat(ComponentSerializer.legacy((ComponentLike)TextBuilder.buildComponent((String)expanded, (Component[])new Component[0])));
    }

    public String getTemplate(Player player) {
        if (this.getConfig().value("template").string() == null) {
            return "<{0}> {1}";
        }
        String wid = ((String)this.getDimensionId.invoke((Object)player.getWorld())).replace("_", "-");
        String world = TextExaminer.examinableText((String)this.getConfig().value("world").string().formatted(wid), (Object[])new Object[0]);
        String template = this.getConfig().value("template").string();
        return PlaceHolderService.formatPlayer((Player)player, (String)template.replace("{world}", world));
    }

    public String getTime() {
        return this.getConfig().value("time").string().formatted(SharedObjects.TIME_FORMAT.format(new Date()));
    }

    @AutoRegister(value={"qb:el"})
    public static final class PaperChatListener
    extends ModuleComponent<ChatFormat> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("io.papermc.paper.event.player.AsyncChatEvent"));
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onChat(AsyncChatEvent event) {
            String template = ((ChatFormat)this.parent).getTemplate(event.getPlayer());
            String time = ((ChatFormat)this.parent).getTime();
            CustomChatRenderer render = CustomChatRenderer.renderer(event);
            if (time.startsWith("<post>")) {
                render.postfix((ComponentLike)TextBuilder.buildComponent((String)time.substring(6), (Component[])new Component[0]));
                template = template.replace("{time}", "");
            } else {
                template = template.replace("{time}", time);
            }
            render.template(template);
        }
    }
}

