/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.Date;
import java.util.function.Function;
import me.gb2022.apm.local.MappedQueryEvent;
import me.gb2022.apm.local.PluginMessageHandler;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleO1;
import me.gb2022.commons.reflect.method.MethodHandleO2;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.platform.PluginPlatform;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.foundation.ComponentSerializer;
import org.tbstcraft.quark.framework.event.BanMessageFetchEvent;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el", "qb:pm"})
@QuarkModule(version="1.0.0")
public final class CustomKickMessage
extends PackageModule {
    public static final MethodHandleO1<PlayerKickEvent, Component> SET_KICK_REASON = (MethodHandleO1)MethodHandle.select(ctx -> {
        ctx.attempt(() -> PlayerKickEvent.class.getMethod("reason", Component.class), (e, c) -> e.reason(c));
        ctx.dummy((e, c) -> e.setReason(ComponentSerializer.legacy((ComponentLike)c)));
    });
    public static final MethodHandleO2<AsyncPlayerPreLoginEvent, AsyncPlayerPreLoginEvent.Result, Component> DISALLOW_LOGIN = (MethodHandleO2)MethodHandle.select(ctx -> {
        ctx.attempt(() -> AsyncPlayerPreLoginEvent.class.getMethod("disallow", AsyncPlayerPreLoginEvent.Result.class, Component.class), (e, r, c) -> e.disallow(r, c));
        ctx.dummy((e, r, c) -> e.disallow(r, ComponentSerializer.legacy((ComponentLike)c)));
    });
    @Inject
    private LanguageEntry language;

    @EventHandler(priority=EventPriority.HIGH)
    public void onKick(PlayerKickEvent event) {
        if (event.getReason().startsWith("\u0002")) {
            event.setReason(event.getReason().replaceFirst("\u0002", ""));
            return;
        }
        String msg = MessageAccessor.buildTemplate((LanguageEntry)this.language, (MinecraftLocale)LocaleService.locale((CommandSender)event.getPlayer()), (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[0]));
        Component c = TextBuilder.buildComponent((String)msg.replace("{reason}", event.getReason()), (Component[])new Component[0]);
        SET_KICK_REASON.invoke((Object)event, (Object)c);
    }

    @PluginMessageHandler(value="quark:kick-message-fetch")
    public void onMessageFetch(MappedQueryEvent event) {
        String msg = (String)event.getProperty("message", String.class);
        if (msg.startsWith("\u0002")) {
            event.setProperty("message", (Object)msg.replaceFirst("\u0002", ""));
            return;
        }
        MinecraftLocale locale = Language.locale((String)((String)event.getProperty("locale", String.class)));
        String ui = MessageAccessor.buildTemplate((LanguageEntry)this.language, (MinecraftLocale)locale, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[0]));
        event.setProperty("message", (Object)PluginPlatform.global().globalFormatMessage(ui.replace("{reason}", msg)));
    }

    @EventHandler
    public void onBanMessageFetch(BanMessageFetchEvent event) {
        event.setMessage(this.buildBanUI(event.getType(), event.getMessage(), event.getExpiration(), event.getTarget(), event.getSource(), MinecraftLocale.minecraft((String)event.getLocale())));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onConnect(AsyncPlayerPreLoginEvent event) {
        String ui;
        MinecraftLocale locale = MinecraftLocale.ZH_CN;
        String player = event.getName();
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)player);
        if (p.getPlayer() != null) {
            locale = LocaleService.locale((CommandSender)p.getPlayer());
        }
        if (Bukkit.getBanList((BanList.Type)BanList.Type.NAME).isBanned(player)) {
            BanEntry entry = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(player);
            if (entry == null) {
                return;
            }
            ui = this.buildBanUI(BanList.Type.NAME, entry.getReason(), entry.getExpiration(), entry.getTarget(), entry.getSource(), locale);
        } else if (Bukkit.getBanList((BanList.Type)BanList.Type.IP).isBanned(player)) {
            BanEntry entry = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(player);
            if (entry == null) {
                return;
            }
            ui = this.buildBanUI(BanList.Type.IP, entry.getReason(), entry.getExpiration(), entry.getTarget(), entry.getSource(), locale);
        } else {
            return;
        }
        DISALLOW_LOGIN.invoke((Object)event, (Object)AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Object)TextBuilder.buildComponent((String)ui, (Component[])new Component[0]));
    }

    public String buildBanUI(BanList.Type type, String reason, Date expiration, String target, String source, MinecraftLocale locale) {
        String msg = type == BanList.Type.NAME ? MessageAccessor.buildTemplate((LanguageEntry)this.language, (MinecraftLocale)locale, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ban-ui", (Function[])new Function[]{s -> s.replace("@type", "ban-name")})) : MessageAccessor.buildTemplate((LanguageEntry)this.language, (MinecraftLocale)locale, (String)Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ban-ui", (Function[])new Function[]{s -> s.replace("@type", "ban-ip")}));
        msg = expiration == null ? msg.replace("{expire}", "(forever)") : msg.replace("{expire}", SharedObjects.DATE_FORMAT.format(expiration));
        msg = reason != null ? msg.replace("{reason}", reason) : msg.replace("{reason}", "(no reason)");
        msg = msg.replace("{name}", target).replace("{source}", source);
        return msg;
    }
}

