/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.texts.ComponentBlock;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.tbstcraft.quark.SharedObjects;
import org.tbstcraft.quark.api.QueryPingEvent;
import org.tbstcraft.quark.data.assets.Asset;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.2")
@CommandProvider(value={MotdCommand.class})
@AutoRegister(value={"qb:el"})
public final class CustomMotd
extends PackageModule
implements QuarkCommandExecutor {
    public static final Pattern PATTERN = Pattern.compile("\\{[a-z]+}");
    private CachedServerIcon cachedServerIcon;
    private YamlConfiguration setting;
    @Inject(value="motd.png;false")
    private Asset motdIcon;
    @Inject(value="motd.yml;false")
    private Asset motdText;
    @Inject
    private Logger logger;
    @Inject
    private LanguageEntry language;

    public void enable() {
        this.motdIcon.getFile();
        this.motdText.getFile();
        this.refreshIcon();
        this.refreshText();
    }

    private void refreshText() {
        this.motdText.asInputStream(s -> {
            try {
                this.setting = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)s));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void refreshIcon() {
        try {
            this.cachedServerIcon = Bukkit.loadServerIcon((File)this.motdIcon.getFile());
        }
        catch (Exception e) {
            this.logger.error("failed to load server icon. please consider refresh icon when fixed.", (Throwable)e);
        }
    }

    public ComponentBlock getMessage() {
        ConfigurationSection root = this.setting.getConfigurationSection("motd");
        if (root == null) {
            throw new RuntimeException("invalid config!");
        }
        Object template = root.getString("motd-title") + "\n{#reset}" + root.getString("motd-subtitle");
        Matcher matcher = PATTERN.matcher((CharSequence)template);
        while (matcher.find()) {
            String content;
            String raw = matcher.group();
            String key = raw.replace("{", "").replace("}", "");
            if (!root.contains(key)) {
                content = key;
            } else if (root.isString(key)) {
                content = root.getString(key);
            } else {
                List list = root.getStringList(key);
                content = (String)list.get(SharedObjects.RANDOM.nextInt(list.size()));
            }
            if (content == null) {
                content = key;
            }
            template = ((String)template).replace(raw, content);
        }
        return TextBuilder.build((String)template, (Component[])new Component[0]);
    }

    @EventHandler
    public void onPing(ServerListPingEvent e) {
        e.setMotd(this.getMessage().toString());
        if (this.cachedServerIcon == null) {
            return;
        }
        e.setServerIcon(this.cachedServerIcon);
    }

    @EventHandler
    public void onPing(QueryPingEvent e) {
        e.setMotd(this.getMessage().toPlainTextString());
        if (this.cachedServerIcon == null) {
            return;
        }
        e.setServerIcon(this.cachedServerIcon);
    }

    public void onCommand(CommandSender sender, String[] args) {
        switch (args[0]) {
            case "refresh-icon": {
                this.refreshIcon();
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"icon-refresh", (Object[])new Object[0]);
                break;
            }
            case "refresh-text": {
                this.refreshText();
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"text-refresh", (Object[])new Object[0]);
                break;
            }
            case "text": {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"motd-command", (Object[])new Object[0]);
                TextSender.sendMessage((CommandSender)sender, (ComponentLike)this.getMessage());
            }
        }
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.add("refresh-icon");
            tabList.add("refresh-text");
            tabList.add("text");
        }
    }

    @QuarkCommand(name="motd", permission="-quark.motd.command")
    public static final class MotdCommand
    extends ModuleCommand<CustomMotd> {
        public void init(CustomMotd module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

