/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.gb2022.commons.reflect.AutoRegister;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.ComponentBlock;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.APIProfileTest;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="0.1")
public final class CustomScoreboard
extends PackageModule {
    private final Map<Player, Scoreboard> scoreboards = new HashMap<Player, Scoreboard>();

    static Objective saveGetObjective(String id, Scoreboard scoreboard) {
        Objective obj = scoreboard.getObjective(id);
        if (obj == null) {
            obj = scoreboard.registerNewObjective(id, "-quark-display");
        }
        return obj;
    }

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("org.bukkit.scoreboard.Scoreboard"));
    }

    public void enable() {
        TaskService.global().timer("quark://scoreboard/update", 1L, 20L, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.setScoreboard(p);
            }
        });
    }

    public void disable() {
        TaskService.global().cancel("quark://scoreboard/update");
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.unsetScoreboard(p);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.unsetScoreboard(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.setScoreboard(event.getPlayer());
    }

    private void setScoreboard(Player player) {
        if (!this.scoreboards.containsKey(player)) {
            this.scoreboards.put(player, Bukkit.getScoreboardManager().getNewScoreboard());
        }
        Scoreboard board = this.scoreboards.get(player);
        Objective buffer1 = CustomScoreboard.saveGetObjective("buffer1", board);
        Objective buffer2 = CustomScoreboard.saveGetObjective("buffer2", board);
        if (buffer1.getDisplaySlot() == null) {
            buffer1.unregister();
            buffer1 = board.registerNewObjective("buffer1", "-quark-display");
            this.build(player, buffer1);
            buffer1.setDisplaySlot(DisplaySlot.SIDEBAR);
            buffer2.setDisplaySlot(null);
        } else {
            buffer2.unregister();
            buffer2 = board.registerNewObjective("buffer2", "-quark-display");
            this.build(player, buffer2);
            buffer2.setDisplaySlot(DisplaySlot.SIDEBAR);
            buffer1.setDisplaySlot(null);
        }
        player.setScoreboard(board);
    }

    private void build(Player player, Objective builder2) {
        MinecraftLocale locale = LocaleService.locale((CommandSender)player);
        ComponentBlock component = this.getLanguage().item("title").component(locale, new Object[0]);
        if (APIProfileTest.isPaperCompat()) {
            builder2.displayName(component.asComponent());
        } else {
            builder2.setDisplayName(LegacyComponentSerializer.legacySection().serialize(component.asComponent()));
        }
        String template = Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"ui", (Function[])new Function[0]);
        String ui = MessageAccessor.buildTemplate((LanguageEntry)this.getLanguage(), (MinecraftLocale)locale, (String)template).replace("{player}", player.getName());
        ui = PlaceHolderService.formatPlayer((Player)player, (String)ui);
        List uiBlock = TextBuilder.buildStringBlocks((String)ui, (Component[])new Component[0]);
        HashMap<String, Integer> existing = new HashMap<String, Integer>();
        for (int i = 0; i < uiBlock.size(); ++i) {
            Object column = (String)uiBlock.get(i);
            if (existing.containsKey(column)) {
                int fix = (Integer)existing.get(column);
                existing.put((String)column, fix + 1);
                column = (String)column + " ".repeat(fix + 1);
            } else {
                existing.put((String)column, 0);
            }
            builder2.getScore((String)column).setScore(uiBlock.size() - i);
        }
    }

    private void unsetScoreboard(Player p) {
        if (!this.scoreboards.containsKey(p)) {
            return;
        }
        this.scoreboards.get(p).clearSlot(DisplaySlot.SIDEBAR);
        this.scoreboards.remove(p);
    }
}

