/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import me.gb2022.commons.reflect.AutoRegister;
import net.kyori.adventure.text.Component;
import org.atcraftmc.qlib.platform.PluginPlatform;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;

@QuarkModule
@AutoRegister(value={"qb:el"})
public final class DropItemInfo
extends PackageModule {
    public void enable() {
        for (World w : Bukkit.getWorlds()) {
            this.discover(w);
        }
    }

    public void disable() {
        for (World w : Bukkit.getWorlds()) {
            for (Entity e : w.getEntities()) {
                if (!(e instanceof Item)) continue;
                Item i = (Item)e;
                i.setCustomName(null);
                i.setCustomNameVisible(false);
            }
        }
    }

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireMethod(() -> Nameable.class.getMethod("customName", Component.class));
    }

    @EventHandler
    public void onDropItem(PlayerDropItemEvent event) {
        this.setId(event.getItemDrop());
    }

    @EventHandler
    public void onBlockDropItem(BlockDropItemEvent event) {
        for (Item i : event.getItems()) {
            this.setId(i);
        }
    }

    @EventHandler
    public void onEntityDropItem(EntityDropItemEvent event) {
        this.setId(event.getItemDrop());
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        TaskService.entity((Entity)entity).delay(1L, () -> {
            for (Entity e : entity.getNearbyEntities(10.0, 10.0, 10.0)) {
                if (!(e instanceof Item)) continue;
                Item i = (Item)e;
                this.setId(i);
            }
        });
    }

    @EventHandler
    public void onEntityDeath(PlayerDeathEvent event) {
        Player entity = event.getEntity();
        TaskService.entity((Entity)entity).delay(1L, () -> {
            for (Entity e : entity.getNearbyEntities(10.0, 10.0, 10.0)) {
                if (!(e instanceof Item)) continue;
                Item i = (Item)e;
                this.setId(i);
            }
        });
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        TaskService.entity((Entity)event.getTarget()).delay(1L, () -> this.setId(event.getTarget()));
    }

    public void discover(World world) {
        for (Entity e : world.getEntities()) {
            if (!(e instanceof Item)) continue;
            Item i = (Item)e;
            this.setId(i);
        }
    }

    public void setId(Item item) {
        String template = "{#red}{amount}{#yellow}x{translate;color(aqua)}{id}{;}";
        ItemStack stack = item.getItemStack();
        Material type = stack.getType();
        String id = (type.isBlock() ? "block." : "item.") + type.getKey().toString().replace(":", ".");
        String s = PluginPlatform.global().globalFormatMessage(template.replace("{amount}", String.valueOf(stack.getAmount())).replace("{id}", id));
        item.customName(TextBuilder.buildComponent((String)s, (Component[])new Component[0]));
        item.setCustomNameVisible(true);
    }
}

