/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.gb2022.commons.nbt.NBTBase;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.nbt.NBTTagList;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleO1;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Nameable;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.foundation.ComponentSerializer;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.BukkitCodec;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.customcontent.CustomMeta;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@AutoRegister(value={"qb:el"})
@CommandProvider(value={HoverDisplayCommand.class})
public final class HoverDisplay
extends PackageModule
implements QuarkCommandExecutor {
    private final Map<String, ArmorStandGroup> stands = new HashMap<String, ArmorStandGroup>();
    @Inject
    private Logger logger;
    @Inject
    private LanguageEntry language;

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("org.bukkit.Nameable"));
        Compatibility.requireMethod(() -> Nameable.class.getDeclaredMethod("customName", new Class[0]));
    }

    public void enable() {
        NBTTagCompound entry = ModuleDataService.getEntry((String)this.getFullId());
        entry.getTagMap().forEach((k, v) -> {
            Location location = BukkitCodec.location((NBTTagCompound)((NBTTagCompound)v).getCompoundTag("location"));
            ArrayList<Component> texts = new ArrayList<Component>();
            if (!((NBTTagCompound)v).hasKey("texts")) {
                texts.add(ComponentSerializer.json((String)((NBTTagCompound)v).getString("text")));
            } else {
                NBTTagList list = ((NBTTagCompound)v).getTagList("texts");
                for (int i = 0; i < list.size(); ++i) {
                    texts.add(ComponentSerializer.json((String)list.getString(i)));
                }
            }
            ArmorStandGroup group = new ArmorStandGroup(location, texts);
            this.stands.put((String)k, group);
        });
        this.logger.info("created %s texts".formatted(this.stands.size()));
    }

    public void disable() {
        NBTTagCompound entry = ModuleDataService.getEntry((String)this.getFullId());
        entry.getTagMap().clear();
        this.stands.forEach((id, s) -> {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList texts = new NBTTagList();
            for (Component text : s.texts) {
                texts.addString(ComponentSerializer.json((ComponentLike)text));
            }
            tag.setTag("texts", (NBTBase)texts);
            tag.setCompoundTag("location", BukkitCodec.nbt((Location)s.anchor));
            entry.setCompoundTag(id, tag);
        });
        ModuleDataService.save((String)this.getFullId());
        this.stands.clear();
        TaskService.global().run(this::clearAll);
    }

    public void clearAll() {
        for (ArmorStandGroup s : this.stands.values()) {
            s.destroy();
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity.getType() != EntityType.ARMOR_STAND || !CustomMeta.hasPDCIdentifier((PersistentDataHolder)entity) || !Objects.equals(CustomMeta.getPDCIdentifier((PersistentDataHolder)entity), "quark:hover-text")) continue;
                entity.remove();
            }
        }
    }

    public void create(String id, Location loc, List<Component> text) {
        ArmorStandGroup group = new ArmorStandGroup(loc, text);
        this.stands.put(id, group);
    }

    public void execute(CommandExecution context) {
        Player sender = context.requireSenderAsPlayer();
        String op = context.requireEnum(0, new String[]{"create", "delete-all", "delete", "edit", "tp"});
        if (Objects.equals(op, "delete-all")) {
            TaskService.global().run(this::clearAll);
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"delete-all", (Object[])new Object[0]);
            return;
        }
        String name = context.requireArgumentAt(1);
        if (Objects.equals(op, "create")) {
            if (this.stands.containsKey(name)) {
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"exist", (Object[])new Object[]{name});
                return;
            }
        } else if (!this.stands.containsKey(name)) {
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"not-found", (Object[])new Object[]{name});
            return;
        }
        switch (op) {
            case "create": {
                this.create(name, sender.getLocation().add(0.0, 1.37, 0.0), this.buildText(context));
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"create", (Object[])new Object[]{name});
                break;
            }
            case "delete": {
                TaskService.global().run(() -> this.stands.remove(name).destroy());
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"delete", (Object[])new Object[]{name});
                break;
            }
            case "edit": {
                this.stands.get(name).edit(this.buildText(context));
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"edit", (Object[])new Object[]{name});
                break;
            }
            case "tp": {
                this.stands.get(name).teleport(sender.getLocation().add(0.0, 1.37, 0.0));
                MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"teleport", (Object[])new Object[]{name});
            }
        }
    }

    private List<Component> buildText(CommandExecution context) {
        return Arrays.stream(context.requireRemainAsParagraph(2, true).split("\\{#return}")).map(x$0 -> TextBuilder.buildComponent((String)x$0, (Component[])new Component[0])).toList();
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"create", "delete", "edit", "tp"});
        suggestion.suggest(1, this.stands.keySet());
    }

    public static final class ArmorStandGroup {
        public static final MethodHandleO1<ArmorStand, Component> CUSTOM_NAME = (MethodHandleO1)MethodHandle.select(ctx -> {
            ctx.attempt(() -> Nameable.class.getMethod("customName", Component.class), (p, c) -> p.customName(c));
            ctx.dummy((a, c) -> a.setCustomName(ComponentSerializer.legacy((ComponentLike)c)));
        });
        private final Set<ArmorStand> components = new HashSet<ArmorStand>();
        private final List<Component> texts = new ArrayList<Component>();
        private Location anchor;

        public ArmorStandGroup(Location anchor, List<Component> texts) {
            this.anchor = anchor;
            this.texts.addAll(texts);
            this.regenerate();
        }

        private void destroy() {
            for (ArmorStand s : this.components) {
                s.remove();
            }
            this.components.clear();
        }

        private void regenerate() {
            this.destroy();
            for (int i = 0; i < this.texts.size(); ++i) {
                Component text = this.texts.get(i);
                Location location = this.anchor.clone().subtract(0.0, 0.244 * (double)i, 0.0);
                this.create(location, text);
            }
        }

        public void edit(List<Component> texts) {
            this.destroy();
            this.texts.clear();
            this.texts.addAll(texts);
            this.regenerate();
        }

        public void teleport(Location location) {
            this.destroy();
            this.anchor = location;
            this.regenerate();
        }

        public void create(Location loc, Component text) {
            ArmorStand stand = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class);
            CustomMeta.setPDCIdentifier((PersistentDataHolder)stand, (String)"quark:hover-text");
            stand.teleport(loc);
            stand.setMarker(true);
            stand.setSmall(true);
            stand.setGravity(false);
            stand.setInvulnerable(true);
            stand.setVisible(false);
            CUSTOM_NAME.invoke((Object)stand, (Object)text);
            stand.setCustomNameVisible(true);
            this.components.add(stand);
        }
    }

    @QuarkCommand(name="hover-display", permission="-quark.hoverdisplay")
    public static final class HoverDisplayCommand
    extends ModuleCommand<HoverDisplay> {
        public void init(HoverDisplay module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

