/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.function.Consumer;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.5.0")
@AutoRegister(value={"qb:el", "qb:rm"})
public final class JoinQuitMessage
extends PackageModule {
    @Inject
    private LanguageEntry language;

    private void broadcast(String name, Consumer<Player> handler) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p == Bukkit.getPlayerExact((String)name)) continue;
            handler.accept(p);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.setJoinMessage(null);
        if (!ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"proxy")) {
            String player = event.getPlayer().getName();
            this.broadcast(player, p -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"join", (Object[])new Object[]{player}));
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)Bukkit.getPlayerExact((String)player), (String)"welcome-message", (Object[])new Object[]{player});
        }
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"sound")) {
            float volume = this.getConfig().value("volume").floatValue();
            event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.BLOCK_PORTAL_TRAVEL, volume, 1.0f);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        event.setQuitMessage(null);
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"proxy")) {
            return;
        }
        String player = event.getPlayer().getName();
        this.broadcast(player, p -> MessageAccessor.send((LanguageEntry)this.language, (CommandSender)p, (String)"leave", (Object[])new Object[]{player}));
    }
}

