/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.List;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.Inject;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0-beta", beta=true)
@CommandProvider(value={NickNameCommand.class})
public class Nickname
extends PackageModule
implements QuarkCommandExecutor {
    private final ProtocolManager service = ProtocolLibrary.getProtocolManager();
    private final PacketListener playerData = new PacketAdapter((Plugin)Quark.getInstance(), new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

        public void onPacketSending(PacketEvent event) {
            PacketContainer packet = event.getPacket();
            List infos = (List)packet.getPlayerInfoDataLists().read(0);
            for (PlayerInfoData data : infos) {
                NBTTagCompound entry;
                Player player;
                if (data == null || (player = Bukkit.getPlayer((String)data.getProfile().getName())) == null || !(entry = PlayerDataService.getEntry((String)player.getName(), (String)Nickname.this.getFullId())).hasKey("value")) continue;
                WrappedGameProfile profile = new WrappedGameProfile(data.getProfile().getUUID(), entry.getString("value"));
                WrappedChatComponent display = data.getDisplayName().deepClone();
                display.setJson("{\"text\":\"%s\"}".formatted(entry.getString("value")));
                PlayerInfoData newData = new PlayerInfoData(profile, data.getLatency(), data.getGameMode(), display);
                infos.set(infos.indexOf(data), newData);
            }
            packet.getPlayerInfoDataLists().write(0, (Object)infos);
        }
    };
    @Inject(value="-quark.nickname.other")
    public Permission setOtherPermission;

    public void enable() {
        this.service.addPacketListener(this.playerData);
    }

    public void disable() {
        this.service.removePacketListener(this.playerData);
    }

    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireClass(() -> Class.forName("com.comphenix.protocol.ProtocolLibrary"));
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggest(0, new String[]{"<name>"});
    }

    public void execute(CommandExecution context) {
        boolean isSelf;
        String name = context.requireArgumentAt(0);
        Player player = context.hasArgumentAt(1) ? context.requirePlayer(1) : context.requireSenderAsPlayer();
        boolean bl = isSelf = player == context.requireSenderAsPlayer();
        if (!isSelf) {
            context.requirePermission(this.setOtherPermission);
        }
        NBTTagCompound entry = PlayerDataService.getEntry((String)player.getName(), (String)this.getFullId());
        entry.setString("value", name);
        PlayerDataService.save((String)player.getName());
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)(isSelf ? "set-self" : "set-other"), (Object[])new Object[]{player.getName(), name});
    }

    @QuarkCommand(name="nickname", permission="+quark.nickname")
    public static final class NickNameCommand
    extends ModuleCommand<Nickname> {
        public void init(Nickname module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

