/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import io.papermc.paper.scoreboard.numbers.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import me.gb2022.commons.reflect.method.MethodHandle;
import me.gb2022.commons.reflect.method.MethodHandleO0;
import me.gb2022.commons.reflect.method.MethodHandleO2;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.config.ConfigContainer;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.atcraftmc.qlib.texts.placeholder.ObjectPlaceHolder;
import org.atcraftmc.qlib.texts.placeholder.StringObjectPlaceHolder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.data.storage.DataEntry;
import org.tbstcraft.quark.foundation.ComponentSerializer;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.APIProfile;
import org.tbstcraft.quark.foundation.platform.APIProfileTest;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.CachedInfo;

@AutoRegister(value={"qb:el"})
@QuarkModule
@QuarkCommand(name="header", permission="-quark.header")
@Components(value={NameTags.class, BelowNameColumns.class})
public final class PlayerNameHeader
extends CommandModule {
    @Inject
    private LanguageEntry language;
    @Inject
    private Logger logger;

    public void enable() {
        super.enable();
        DataEntry legacy = ModuleDataService.get((String)"player-name-header");
        ArrayList keys = new ArrayList(legacy.getTagMap().keySet());
        for (String player : keys) {
            try {
                DataEntry fixed = PlayerDataService.get((String)player);
                fixed.set("player-name-header", (Object)legacy.getString(player));
                legacy.getTagMap().remove(player);
                fixed.save();
                this.logger.info("moved playerData handle of {} to modern format.", (Object)player);
            }
            catch (Exception e) {
                this.logger.error("failed to move playerData handle of %s".formatted(player), (Throwable)e);
            }
        }
        legacy.save();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.attach(p);
        }
        PlaceHolderService.PLAYER.register("rank", (ObjectPlaceHolder)((StringObjectPlaceHolder)this::getHeader));
    }

    public void disable() {
        super.disable();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.detach(p);
        }
        PlaceHolderService.PLAYER.unregister("rank");
    }

    public void onCommand(CommandSender sender, String[] args) {
        Player p = Bukkit.getPlayerExact((String)args[1]);
        DataEntry entry = PlayerDataService.get((String)args[1]);
        if (Objects.equals(args[0], "set")) {
            entry.set("player-name-header", (Object)args[2]);
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"set-header", (Object[])new Object[]{args[1], args[2]});
        }
        if (Objects.equals(args[0], "clear")) {
            entry.remove("player-name-header");
            MessageAccessor.send((LanguageEntry)this.language, (CommandSender)sender, (String)"clear-header", (Object[])new Object[]{args[1]});
        }
        if (p != null && p.isOnline()) {
            this.attach(p);
        }
        entry.save();
    }

    public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
        if (buffer.length == 1) {
            tabList.add("set");
            tabList.add("clear");
        }
        if (buffer.length == 2) {
            tabList.addAll(CachedInfo.getAllPlayerNames());
        }
        if (buffer.length == 3 && Objects.equals(buffer[0], "set")) {
            tabList.add("<header>");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.attach(event.getPlayer());
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        this.detach(event.getPlayer());
    }

    public void attach(Player p) {
        Component name = this.getPlayerName(p);
        String string = LegacyComponentSerializer.legacySection().serialize(name);
        if (APIProfileTest.adventurePlatform()) {
            try {
                p.playerListName(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            p.customName(name);
            p.displayName(name);
        } else {
            try {
                p.setPlayerListName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            p.setCustomName(string);
            p.setCustomNameVisible(false);
        }
        if (APIProfileTest.isFoliaServer()) {
            return;
        }
        p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public void detach(Player p) {
        p.setDisplayName(p.getName());
        p.setPlayerListName(p.getName());
    }

    public String getHeader(Player player) {
        DataEntry data = PlayerDataService.get((Player)player);
        String header = data.hasKey("player-name-header") ? data.getString("player-name-header") : (player.isOp() ? this.getConfig().value("op-header").string() : this.getConfig().value("player-header").string());
        return "{;}" + header + "{;}";
    }

    public Component getPlayerName(Player player) {
        String header = this.getHeader(player);
        String template = this.getConfig().value("template").string();
        if (template == null) {
            return Component.text((String)player.getName());
        }
        return TextBuilder.buildComponent((String)PlaceHolderService.format((String)template.replace("{player}", player.getName()).replace("{header}", header + "{;}")), (Component[])new Component[0]);
    }

    public Component getPlayerSuffix(Player player) {
        String header = this.getHeader(player);
        String[] template = Objects.requireNonNull(this.getConfig().value("template").string()).split("\\{player}");
        if (template.length == 1) {
            return Component.text((String)"");
        }
        return TextBuilder.buildComponent((String)PlaceHolderService.format((String)template[template.length - 1].replace("{header}", header)), (Component[])new Component[0]);
    }

    public Component getPlayerPrefix(Player player) {
        String header = this.getHeader(player);
        String[] template = Objects.requireNonNull(this.getConfig().value("template").string()).split("\\{player}");
        return TextBuilder.buildComponent((String)PlaceHolderService.format((String)template[0].replace("{header}", header)), (Component[])new Component[0]);
    }

    public static final class ProtocolLibNameTags
    extends ModuleComponent<PlayerNameHeader> {
        private final ProtocolManager service = ProtocolLibrary.getProtocolManager();
        private final PacketListener entityMeta = new PacketAdapter((Plugin)Quark.getInstance(), new PacketType[]{PacketType.Play.Server.ENTITY_METADATA}){

            public void onPacketSending(PacketEvent event) {
                int entityId = (Integer)event.getPacket().getIntegers().read(0);
                PacketContainer packet = event.getPacket();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (entityId != player.getEntityId()) continue;
                    WrappedDataWatcher watcher = new WrappedDataWatcher();
                    WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true);
                    WrappedDataWatcher.WrappedDataWatcherObject displayNameObject = new WrappedDataWatcher.WrappedDataWatcherObject(2, serializer);
                    WrappedChatComponent displayName = WrappedChatComponent.fromJson((String)ComponentSerializer.json((ComponentLike)((PlayerNameHeader)parent).getPlayerName(player)));
                    watcher.setObject(displayNameObject, Optional.of(displayName.getHandle()));
                    packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
                    return;
                }
            }
        };
        private final PacketListener playerData = new PacketAdapter((Plugin)Quark.getInstance(), new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

            public void onPacketSending(PacketEvent event) {
                PacketContainer packet = event.getPacket();
                List infos = (List)packet.getPlayerInfoDataLists().read(0);
                for (PlayerInfoData data : infos) {
                    Player player = Bukkit.getPlayer((String)data.getProfile().getName());
                    if (player == null) continue;
                    Component name = ((PlayerNameHeader)parent).getPlayerName(player);
                    WrappedChatComponent displayName = WrappedChatComponent.fromJson((String)ComponentSerializer.json((ComponentLike)name));
                    PlayerInfoData newData = new PlayerInfoData(data.getProfile(), data.getLatency(), data.getGameMode(), displayName);
                    infos.set(infos.indexOf(data), newData);
                }
                packet.getPlayerInfoDataLists().write(0, (Object)infos);
            }
        };

        public void enable() {
            this.service.addPacketListener(this.playerData);
            this.service.addPacketListener(this.entityMeta);
        }

        public void disable() {
            this.service.removePacketListener(this.playerData);
            this.service.removePacketListener(this.entityMeta);
        }

        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.assertion((boolean)false);
            Compatibility.requireClass(() -> Class.forName("com.comphenix.protocol.ProtocolLibrary"));
        }
    }

    public static final class BelowNameColumns
    extends ModuleComponent<PlayerNameHeader> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("io.papermc.paper.scoreboard.numbers.NumberFormat"));
            Compatibility.assertion((boolean)ConfigContainer.getInstance().value("quark-display:player-name-header:below-name-enable").bool());
        }

        public Component build(Player player, MinecraftLocale locale) {
            String template = Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"below-name", (Function[])new Function[0]);
            String ui = MessageAccessor.buildTemplate((LanguageEntry)this.getLanguage(), (MinecraftLocale)locale, (String)template);
            ui = PlaceHolderService.formatPlayer((Player)player, (String)ui);
            return TextBuilder.buildComponent((String)ui, (Component[])new Component[0]);
        }

        public void enable() {
            TaskService.global().timer("render-below-name", 0L, 20L, this::render);
        }

        public void disable() {
            TaskService.global().cancel("render-below-name");
        }

        public void render() {
            for (Player view : Bukkit.getOnlinePlayers()) {
                Scoreboard scoreboard = view.getScoreboard();
                Objective obj = scoreboard.getObjective("below-name");
                if (obj == null) {
                    obj = scoreboard.registerNewObjective("below-name", "@quark");
                }
                obj.setDisplaySlot(DisplaySlot.BELOW_NAME);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    obj.displayName(this.build(player, LocaleService.locale((CommandSender)view)));
                    obj.getScore((OfflinePlayer)player).numberFormat((NumberFormat)NumberFormat.fixed((ComponentLike)this.build(player, LocaleService.locale((CommandSender)view))));
                }
            }
        }
    }

    public static final class NameTags
    extends ModuleComponent<PlayerNameHeader> {
        private static final MethodHandleO2<Team, Component, Component> TEAM_PREFIX = (MethodHandleO2)MethodHandle.select(ctx -> {
            ctx.attempt(() -> Team.class.getMethod("prefix", Component.class), (t, c1, c2) -> {
                t.prefix(c1);
                t.suffix(c2);
            });
            ctx.dummy((t, c1, c2) -> {
                t.setPrefix(ComponentSerializer.legacy((ComponentLike)c1));
                t.setSuffix(ComponentSerializer.legacy((ComponentLike)c2));
            });
        });
        private static final MethodHandleO0<Team> SET_NAME_TAG_VISIBILITY = (MethodHandleO0)MethodHandle.select(ctx -> {
            ctx.attempt(() -> {
                Class.forName("org.bukkit.scoreboard.Team.Option");
                return null;
            }, t -> t.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS));
            ctx.attempt(() -> Team.class.getMethod("setNameTagVisibility", NameTagVisibility.class), t -> t.setNameTagVisibility(NameTagVisibility.ALWAYS));
            ctx.dummy(t -> {});
        });

        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("org.bukkit.scoreboard.Team"));
            Compatibility.requireClass(() -> Class.forName("org.bukkit.scoreboard.Team"));
            Compatibility.blackListPlatform((APIProfile[])new APIProfile[]{APIProfile.FOLIA});
        }

        public void enable() {
            TaskService.global().timer("render-name-tags", 1L, 20L, this::render);
        }

        public void disable() {
            TaskService.global().cancel("render-name-tags");
        }

        public void render() {
            for (Player view : Bukkit.getOnlinePlayers()) {
                Scoreboard scoreboard = view.getScoreboard();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String tid = "quark@" + player.getName().hashCode();
                    Team t = scoreboard.getTeam(tid);
                    if (t == null) {
                        t = scoreboard.registerNewTeam(tid);
                    }
                    SET_NAME_TAG_VISIBILITY.invoke((Object)t);
                    TEAM_PREFIX.invoke((Object)t, (Object)((PlayerNameHeader)this.parent).getPlayerPrefix(player), (Object)((PlayerNameHeader)this.parent).getPlayerSuffix(player));
                    t.addPlayer((OfflinePlayer)player);
                }
            }
        }
    }
}

