/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.display;

import java.util.function.Function;
import me.gb2022.commons.reflect.AutoRegister;
import net.kyori.adventure.text.Component;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.Language;
import org.atcraftmc.qlib.language.LanguageContainer;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.TextBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.AudienceService;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;

@AutoRegister(value={"qb:el"})
@QuarkModule(version="2.0.3")
public final class TabMenu
extends PackageModule {
    public static final String UPDATE_TASK_TID = "quark_display:tab_menu:update";

    public void enable() {
        TaskService.async().timer(UPDATE_TASK_TID, 0L, 20L, this::update);
        BukkitUtil.registerEventListener((Listener)this);
        this.update();
    }

    public void disable() {
        TaskService.async().cancel(UPDATE_TASK_TID);
        for (Player p : Bukkit.getOnlinePlayers()) {
            Players.setPlayerTab((Player)p, (String)"", (String)"");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.setPlayerList(event.getPlayer());
    }

    private void update() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.setPlayerList(p);
        }
    }

    public void setPlayerList(Player player) {
        MinecraftLocale locale = LocaleService.locale((CommandSender)player);
        LanguageContainer lang = Quark.lang();
        String header = lang.inline(Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"header-ui", (Function[])new Function[0]), locale, "quark-display:tab-menu");
        String footer = lang.inline(Language.generateTemplate((ConfigEntry)this.getConfig(), (String)"footer-ui", (Function[])new Function[0]), locale, "quark-display:tab-menu");
        header = PlaceHolderService.formatPlayer((Player)player, (String)header);
        footer = PlaceHolderService.formatPlayer((Player)player, (String)footer);
        Component h = TextBuilder.buildComponent((String)header, (Component[])new Component[0]);
        Component f = TextBuilder.buildComponent((String)footer, (Component[])new Component[0]);
        AudienceService.of((Player)player).sendPlayerListHeaderAndFooter(h, f);
    }
}

